#pragma once

#include <util/digest/sequence.h>

#include <infra/yasm/stockpile_client/state.h>
#include <infra/monitoring/common/logging.h>

namespace NCollector {
    using TTagValuesMap = THashMap<TString, TVector<TString>>;

    struct THostsResult {
        TSet<std::pair<TString, TString>> Hosts;
        size_t Total = 0;
    };
    using TUniqLabelsResult = THashSet<TVector<std::pair<TString, TString>>, TSimpleRangeHash>;

    enum class EHostTypeArgFlags {
        HOST = 1,
        GROUP = 2,
        METAGROUP = 4,
    };
    Y_DECLARE_FLAGS(THostTypeArg, EHostTypeArgFlags);
    Y_DECLARE_OPERATORS_FOR_FLAGS(THostTypeArg);

    enum class ESortType {
        ASC,
        DESC
    };

    enum class ESelectorType {
        EQUAL_GLOB,
        NOT_EQUAL_GLOB,
        EQUAL_VALUE,
        NOT_EQUAL_VALUE,
        EQUAL_REGEX,
        NOT_EQUAL_REGEX,
    };

    class TSelectorBuilder {
    public:
        TSelectorBuilder();
        void AddValues(const TString &key, const TVector<TString>& values,
                       ESelectorType selectorType = ESelectorType::EQUAL_VALUE,
                       bool prepareForRegexp = false);
        void AddPattern(const TString &key, const TMaybe<TString>& pattern);
        void AddSignalsAndTags(const TVector<TString>& signals, const TTagValuesMap& tags);
        TString ToString() const;
    private:
        TStringBuf SelectorTypeToString(ESelectorType selectorType) const;

        TVector<std::tuple<TString, TString, ESelectorType>> KeysWithValues;
    };

    class TDataProxyReader {
    public:
        TDataProxyReader(NHistDb::NStockpile::TDataProxyMultiClusterState& dataProxyState, NMonitoring::TRequestLog& logger);

        // Returns map to sorted vector of tagkeys. Order is important for UI suggest. GOLOVAN-7236
        THashMap<TString, TVector<TString>> FindTagsForItypes(const TSet<TString>& itypes, TInstant deadline = TInstant::Zero());
        THostsResult FindHosts(const TSet<TString>& itypes, THostTypeArg hostTypes,
                               const TTagValuesMap& tags, const TVector<TString>& signals, size_t limit,
                               const TMaybe<TString>& hostPattern, const THashMap<TString, TString>& groupToMetagroupMap,
                               TInstant deadline = TInstant::Zero());
        TSet<TString> FindKeyValues(const TSet<TString>& itypes, const TString& requestedKey, const TTagValuesMap& tags,
                                    const TVector<TString>& hosts, const TVector<TString>& signals, const TMaybe<TString>& pattern,
                                    const TSet<TString>& metagroups, size_t limit, TInstant deadline = TInstant::Zero());
        TUniqLabelsResult FindUniqueLabels(const TSet<TString>& itypes, const TTagValuesMap& tags, const TVector<TString>& hosts,
                                           const TVector<TString>& signals, const TSet<TString>& keys, bool needItype,
                                           const TSet<TString>& metagroups, TInstant deadline = TInstant::Zero());

    private:
        TSet<TString> HostTypesToKeySet(THostTypeArg hostTypes) const;
        TVector<TSelectorBuilder> SelectorsFromHosts(const TVector<TString>& hosts, const TSet<TString>& metagroups,
                                                     const TSelectorBuilder& selectorBuilder, bool onlyHostShards = false) const;

        NHistDb::NStockpile::TDataProxyMultiClusterState& DataProxyState;
        NMonitoring::TRequestLog& Logger;
        NHistDb::NStockpile::TGrpcStateLoggingHandler<NMonitoring::TRequestLog> GrpcHandler;
    };
}
