#pragma once

#include <infra/monitoring/common/settings.h>
#include <infra/yasm/stockpile_client/settings.h>

namespace {
    TString DATA_PROXY_CLUSTER_TYPE("data-proxy-cluster-type");
}

namespace NCollector {
    class TServerSettings final : public NMonitoring::TSettings {
    public:
        inline void SetDataProxyClusterTypeFromString(const TString& value) {
            DataProxyClusterType = NHistDb::NStockpile::GetStockpileClusterType(value);
        }

        inline NHistDb::NStockpile::EStockpileClusterType GetDataProxyClusterType() const {
            return DataProxyClusterType;
        }

        void ProcessParsedOptions(const NLastGetopt::TOptsParseResult& parsed) {
            SetDataProxyClusterTypeFromString(parsed.GetOrElse(DATA_PROXY_CLUSTER_TYPE, "prestable"));
        }

        static void FillParser(NLastGetopt::TOpts& options) {
            options.AddLongOption(DATA_PROXY_CLUSTER_TYPE, "which data-proxy cluster will be used").Optional().RequiredArgument();
        }
    protected:
        void FillFromFileConfig(const NConfig::TConfig& config) override {
            TSettings::FillFromFileConfig(config);
        }
    private:
        NHistDb::NStockpile::EStockpileClusterType DataProxyClusterType = NHistDb::NStockpile::EStockpileClusterType::Prestable;
    };
}
