#pragma once

#include "fast_config.h"

#include <library/cpp/protobuf/json/json2proto.h>

namespace NYasm::NCommon::NTest {
    const TString SIMPLE_CONFIG_STRING = R"#({
        "Options": []
    })#";

    const TString SIMPLE_CONFIG_STRING_WITH_OPTIONS = R"#({
        "Options": [],
        "DisableStockpileDumpOptions": [],
        "DisableStockpileReadOptions": [],
        "BanItypeSubscriptionsOptions": [],
        "MirrorHistdbReadsOptions": []
    })#";

    const TString MOCKED_CONFIG_STRING_DEPRECATED = R"#({
        "Options": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100},
                "Flag": "DISABLE_STOCKPILE_DUMP"
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 0},
                "Flag": "DISABLE_STOCKPILE_READ"
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prestable",
                    "Percent": 100},
                "Flag": "DISABLE_STOCKPILE_READ"
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Flag": "BAN_ITYPE_SUBSCRIPTIONS",
                "Values": ["banneditype"]
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Flag": "BAN_ITYPE_SUBSCRIPTIONS",
                "Values": ["anotherbanneditype"]
            }
        ]
    })#";

    const TString MOCKED_CONFIG_STRING_DEPRECATED_EXTRA_FIELDS = R"#({
        "Options": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100},
                "Flag": "DISABLE_STOCKPILE_DUMP"
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 0},
                "Flag": "DISABLE_STOCKPILE_READ"
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prestable",
                    "Percent": 100},
                "Flag": "DISABLE_STOCKPILE_READ"
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Flag": "BAN_ITYPE_SUBSCRIPTIONS",
                "Values": ["banneditype"]
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Flag": "BAN_ITYPE_SUBSCRIPTIONS",
                "Values": ["anotherbanneditype"]
            }
        ],
        "ExtraFirstOption": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100},
                "Flag": "DISABLE_STOCKPILE_DUMP"
            }
        ],
        "ExtraSecondOption": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100}
            }
        ]
    })#";

    const TString MOCKED_CONFIG_STRING_DEPRECATED_TRANSITION_TO_ACTUAL = R"#({
        "Options": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100},
                "Flag": "DISABLE_STOCKPILE_DUMP"
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 0},
                "Flag": "DISABLE_STOCKPILE_READ"
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prestable",
                    "Percent": 100},
                "Flag": "DISABLE_STOCKPILE_READ"
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Flag": "BAN_ITYPE_SUBSCRIPTIONS",
                "Values": ["banneditype"]
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Flag": "BAN_ITYPE_SUBSCRIPTIONS",
                "Values": ["anotherbanneditype"]
            }
        ],
        "DisableStockpileDumpOptions": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100}
            }
        ],
        "DisableStockpileReadOptions": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 0}
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prestable",
                    "Percent": 100}
            }
        ],
        "BanItypeSubscriptionsOptions": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Values": ["banneditype"]
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Values": ["anotherbanneditype"]
            }
        ],
        "MirrorHistdbReadsOptions": []
    })#";

    const TString MOCKED_CONFIG_STRING_ACTUAL = R"#({
        "Options": [],
        "DisableStockpileDumpOptions": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100}
            }
        ],
        "DisableStockpileReadOptions": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 0}
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prestable",
                    "Percent": 100}
            }
        ],
        "BanItypeSubscriptionsOptions": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Values": ["banneditype"]
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Values": ["anotherbanneditype"]
            }
        ],
        "MirrorHistdbReadsOptions": []
    })#";

    const TString MOCKED_CONFIG_STRING_ACTUAL_CHANGED = R"#({
        "Options": [],
        "DisableStockpileDumpOptions": [],
        "DisableStockpileReadOptions": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100}
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prestable",
                    "Percent": 100}
            }
        ],
        "BanItypeSubscriptionsOptions": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Values": ["banneditype"]
            },
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                },
                "Values": ["anotherbanneditype"]
            }
        ],
        "ForceLegacyTypesConversion": [
            {
                "Matcher": {
                    "RequestKey": "itype=itype;ctype=prod",
                    "Percent": 100
                }
            }
        ]
    })#";

    const TString MOCKED_CONFIG_STRING_ACTUAL_FAILED = R"#({
        "Options": [],
        "DisableStockpileDumpOptions": [],
        "DisableStockpileReadOptions": [
    })#";

    class TYtMockedFastConfig : public TFastConfig {
    public:
        TYtMockedFastConfig(
            TLog& logger,
            TFastConfigSettings settings,
            TString configString = MOCKED_CONFIG_STRING_ACTUAL
        )
            : TFastConfig(logger, settings)
            , ConfigString(std::move(configString))
        {
        }
    private:
        TString ConfigString;
        TMaybe<TConfig> GetFromYt() override {
            TConfig config {};
            NProtobufJson::Json2Proto(ConfigString, config);
            return {std::move(config)};
        }
    };

    class TYtBrokenMockedFastConfig : public TFastConfig {
    public:
        TYtBrokenMockedFastConfig(
            TLog& logger,
            TFastConfigSettings settings
        )
            : TFastConfig(logger, settings)
        {
        };
    private:
        TMaybe<TConfig> GetFromYt() override {
            ythrow yexception() << "some YT problem";
        }
    };

    class TYtRefreshingFastConfig : public TFastConfig {
    public:
        TYtRefreshingFastConfig(
                TLog& logger,
                TFastConfigSettings settings,
                TDuration interval,
                TVector<TString> configStringsSequence
        )
                : TFastConfig(logger, settings, interval)
                , ConfigStringsSequence(std::move(configStringsSequence))
                , currentConfigStringIterator(ConfigStringsSequence.begin())
        {
        };

        void CompulsoryTick() {
            Tick();
        }
    private:
        TMaybe<TConfig> GetFromYt() override {
            TString configString = *currentConfigStringIterator++;

            TConfig config {};
            NProtobufJson::Json2Proto(configString, config);
            return {std::move(config)};
        }
        const TVector<TString> ConfigStringsSequence;
        TVector<TString>::const_iterator currentConfigStringIterator;
    };
}
