# coding: utf-8

from util.generic.ptr cimport THolder
from util.generic.string cimport TString
from libcpp cimport bool as bool_t

cdef extern from "infra/yasm/common/config/python/helper.h" namespace "NYasm::NCommon":

    TFastConfig* MakeYasmFastConfig(TLog& log, const TString& localPath) except +

    cdef cppclass TFastConfig:
        void Start() except +
        bool_t Has(const TString& flag) except +;

cdef extern from "library/cpp/logger/log.h":
    cdef cppclass TLog:
        TLog() nogil except +

cdef class FastConfig:

    cdef THolder[TFastConfig] _c_fast_config
    cdef TLog _c_log

    def __init__(self, local_path):
        self._c_fast_config.Reset(MakeYasmFastConfig(self._c_log, local_path))

    def start(self):
        self._c_fast_config.Get().Start()

    def has(self, flag_str):
        # TODO(rocco66) replace it to Enum usage after histfront will have migrated to arcadia
        return self._c_fast_config.Get().Has(flag_str)
