#include "metagroup_groups.h"

#include <library/cpp/resource/resource.h>

namespace NYasm::NGroups {
namespace {
THashMap<TString, TVector<TString>> MakeMetagroupToGroupsListProdMap() {
    THashMap<TString, TVector<TString>> table;

    TString conf = NResource::Find("groups.txt");
    TStringBuf total(conf);
    while (total) {
        TStringBuf left;
        TStringBuf right;
        total.Split('\n', left, right);
        total = right;

        TStringBuf metagroup;
        TStringBuf group;
        left.Split(' ', metagroup, group);

        table[metagroup].emplace_back(group);
    }

    return table;
}

THashMap<TString, TVector<TString>> MakeMetagroupToGroupsListPrestableMap() {
    return {
        {
            "ASEARCH",
            {
                "MYT.000",
                "SAS.000",
                "VLA.025.0",
                "VLA.025.1",
            }
        },

        {
            "CON",
            {
                "CON_MYT.0.0",
                "CON_MYT.0.1",
            }
        },

        {
            "QLOUD",
            {
                "QLOUD_GOLOVAN_MYT.5.0",
                "QLOUD_GOLOVAN_MYT.5.1",
            }
        },

        {
            "TESTIT_PRESTABLE",
            {
                "SAS_TESTIT_PRESTABLE",
                "SAS_TESTIT_PRESTABLE_COPY",
            }
        },

        {
            "YASM_ZOOM",
            {
                "ZOOM_CONTROL",
                "ZOOM_CONTROL_SERVER",
                "ZOOM_TARGET",
                "ZOOM_TARGET_SERVER",
            }
        },
    };
}

THashMap<TString, TVector<TString>> MakeMetagroupToGroupsListProdWIthHistNodesMap() {
    auto result = MakeMetagroupToGroupsListProdMap();
    THashMap<TString, TVector<TString>> historyGroups = {
        {
            "ABALANCER",
            {
                "AMS1_BALANCER",
                "BALANCER0",
                "BALANCER2",
                "BALANCER5",
                "BALANCER6",
                "BALANCER7",
                "BALANCER8",
                "BALANCER9",
                "MAN_BALANCER",
                "SAS1_BALANCER"
            }
        },
        {
            "AMETA_NEWS", {"AMETA_NEWS",}
        },
        {
            "APE_CLOUD",
            {
                "APE_CLOUD_FOL",
                "APE_CLOUD_MYT",
                "APE_CLOUD_UGR",
            }
        },
        {
            "APE_FRONT",
            {
                "APE_FRONT_FOL",
                "APE_FRONT_SAS",
                "APE_FRONT_UGR"
            }
        },
        {
            "APE_TEST_FRONT",
            {
                "APE_TEST_FRONT_FOL",
                "APE_TEST_FRONT_SAS"
            }
        },
        {
            "ASEARCH",
            {
                "ADDRS2",
                "ADDRS5",
                "ADDRS6",
                "ADDRS8",
                "ADDRS_MAN",
                "ADDRS_MYT",
                "AMS1_ADDRS",
                "AMS1_MMETA",
                "AMS1_SEARCH.0",
                "AMS1_SEARCH.1",
                "AMS1_SEARCH.2",
                "AMS1_SEARCH.3",
                "AMS1_SERVICE_WIZARD",
                "AMS_SERVICE_WIZARD_WIZARD",
                "AMS_WIZARD",
                "AMS_WIZARD_WIZARD",
                "ANTIROBOT_EX10",
                "ANTIROBOT_EX11",
                "ANTIROBOT_EX26",
                "ANTIROBOT_EX29",
                "ANTIROBOT_EX35",
                "ANTIROBOT_EX37",
                "ANTIROBOT_EX9",
                "ARCNEWS6",
                "ARCNEWS7",
                "ARCNEWS8",
                "FOL-1.0",
                "FOL-1.1",
                "FOL-2.0",
                "FOL-2.1",
                "FOL-3.0",
                "FOL-4.0",
                "FOL-4.1",
                "FOL-5.0",
                "FOL-5.1",
                "FOL-6.0",
                "FOL-6.1",
                "FOL-7.0",
                "FOL-7.1",
                "FOL-7.2",
                "FSEARCH2.0",
                "FSEARCH2.1",
                "IMGS13",
                "IMGS14",
                "IMGS15",
                "IMGS19",
                "IMGS24",
                "IMGS28",
                "IMGS30",
                "IMGS33",
                "IMGS6",
                "IMGS7",
                "IMPROXY4",
                "IMPROXY5",
                "IMPROXY7",
                "IVA-1.0",
                "IVA-2.0",
                "IVA-3.0",
                "IVA-4.0",
                "IVA-5.0",
                "IVA-6.0",
                "IVA-7.0",
                "IVA-7.1",
                "IVA-8.0",
                "IVA.000",
                "IVA.001",
                "IVA.002",
                "IVA.003",
                "IVA.004",
                "IVA1",
                "LAS_NMETA_MSK",
                "MAN1.0",
                "MAN1.1",
                "MAN1.2",
                "MAN1.3",
                "MAN1.4",
                "MAN1.5",
                "MAN1.6",
                "MAN1.7",
                "MAN2.0",
                "MAN2.1",
                "MAN2.2",
                "MAN2.3",
                "MAN2.4",
                "MAN2.5",
                "MAN2.6",
                "MAN2.7",
                "MAN3.0",
                "MAN4.0",
                "MAN4.1",
                "MAN4.2",
                "MAN4.3",
                "MAN5.0",
                "MAN5.1",
                "MAN5.2",
                "MAN5.3",
                "MAN_OLD.001",
                "MAN_OLD.006",
                "MAN_OLD.007",
                "MAN_OLD.009",
                "MAN_OLD.011",
                "MAN_OLD.017",
                "MAN_OLD.018",
                "MAN_OLD.019",
                "MAN_OLD.020",
                "MAN_OLD.022",
                "MAN_OLD.025",
                "MAN_OLD.026",
                "MAN_OLD.027",
                "MAN_OLD.032",
                "MAN_OLD.034",
                "MAN_OLD.036",
                "MAN_OLD.037",
                "MAN_OLD.038",
                "MAN_OLD.039",
                "MAN_OLD.040",
                "MAN_OLD.042",
                "MAN_OLD.043",
                "MAN_OLD.044",
                "MAN_VM_OLD.001",
                "META_HAMSTER",
                "MISCSEARCH_06",
                "MISCSEARCH_07",
                "MISCSEARCH_08",
                "MMB",
                "MMETA10",
                "MMETA11",
                "MMETA12",
                "MMETA13",
                "MMETA14",
                "MMETA15",
                "MMETA16",
                "MMETA18",
                "MMETA19",
                "MMETA21",
                "MMETA22",
                "MMETA24",
                "MMETA26",
                "MMETA27",
                "MMETA28",
                "MMETA29",
                "MMETA30",
                "MMETA31",
                "MMETA33",
                "MMETA34",
                "MMETA35",
                "MMETA6",
                "MMETA7",
                "MMETA9",
                "MNEWS1",
                "MNEWS2",
                "MNEWS3",
                "MSK_L7_BALANCER",
                "MSK_L7_BALANCER_TEST",
                "MSK_MENACE_BALANCER",
                "MSK_MISC_NMETA",
                "MYT-1.0",
                "MYT-2.0",
                "MYT-3.0",
                "MYT-3.1",
                "MYT-4.0",
                "MYT-4.1",
                "MYT-5.0",
                "MYT-5.1",
                "MYT-6.0",
                "NMETA3",
                "NMETA6",
                "NMETA7",
                "NMETA8",
                "NMETA_EX35",
                "NMETA_SF_SEPE_6060",
                "NWIZARD2",
                "NWIZARD3",
                "NWIZARD4",
                "QSEARCH22",
                "SAS-0.9_A",
                "SAS-0.9_B",
                "SAS-0.9_C",
                "SAS-1.1.1",
                "SAS-1.1.2",
                "SAS-1.1.3",
                "SAS-1.1.4",
                "SAS-1.2.1_A",
                "SAS-1.2.1_B",
                "SAS-1.2.2",
                "SAS-1.3.1",
                "SAS-1.3.1_A",
                "SAS-1.3.1_B",
                "SAS-1.3.1_C",
                "SAS-1.3.2",
                "SAS-1.3.2_A",
                "SAS-1.3.2_B",
                "SAS-1.3.2_C",
                "SAS-1.3.3_A",
                "SAS-1.3.3_B",
                "SAS-1.3.3_C",
                "SAS-1.3.3_D",
                "SAS-1.3.4_A",
                "SAS-1.3.4_B",
                "SAS-1.3.4_C",
                "SAS-1.3.4_D",
                "SAS-1.3.4_E",
                "SAS-1.3.4_F",
                "SAS-1.4.1_A",
                "SAS-1.4.1_B",
                "SAS-1.4.2_A",
                "SAS-1.4.2_B",
                "SAS-1.4.3",
                "SAS-1.4.4_A",
                "SAS-1.4.4_B",
                "SAS-1.4.4_C",
                "SAS-1.4.4_D",
                "SAS-2.1.1_A",
                "SAS-2.1.1_B",
                "SAS-2.1.2",
                "SAS-2.1.3",
                "SAS-2.1.4",
                "SAS-2.3.1",
                "SAS-2.3.2",
                "SAS-2.3.3",
                "SAS-2.3.4",
                "SAS-2.4.1",
                "SAS-2.4.2",
                "SAS-2.4.3",
                "SAS-2.4.4",
                "SAS1.0",
                "SAS1.1",
                "SAS1.2",
                "SAS1.3",
                "SAS1.4",
                "SAS1.5",
                "SAS1.6",
                "SAS_MISC_NMETA",
                "SAS_NMETA1",
                "SAS_NMETA2",
                "SAS_REFRESH_TEMP",
                "SEARCH10.0",
                "SEARCH10.1",
                "SEARCH11.0",
                "SEARCH11.1",
                "SEARCH12.0",
                "SEARCH12.1",
                "SEARCH13.0",
                "SEARCH13.1",
                "SEARCH14.0",
                "SEARCH14.1",
                "SEARCH15.0",
                "SEARCH15.1",
                "SEARCH16.0",
                "SEARCH16.1",
                "SEARCH18.0",
                "SEARCH18.1",
                "SEARCH19.0",
                "SEARCH19.1",
                "SEARCH2.0",
                "SEARCH2.1",
                "SEARCH21.0",
                "SEARCH21.1",
                "SEARCH22.0",
                "SEARCH22.1",
                "SEARCH24.0",
                "SEARCH24.1",
                "SEARCH25.0",
                "SEARCH25.1",
                "SEARCH26.0",
                "SEARCH26.1",
                "SEARCH27.0",
                "SEARCH27.1",
                "SEARCH28.0",
                "SEARCH28.1",
                "SEARCH29.0",
                "SEARCH29.1",
                "SEARCH30.0",
                "SEARCH30.1",
                "SEARCH31.0",
                "SEARCH31.1",
                "SEARCH32",
                "SEARCH33.0",
                "SEARCH33.1",
                "SEARCH34.0",
                "SEARCH34.1",
                "SEARCH35.0",
                "SEARCH35.1",
                "SEARCH35.2",
                "SEARCH35.3",
                "SEARCH36.0",
                "SEARCH36.1",
                "SEARCH36.2",
                "SEARCH36.3",
                "SEARCH37.0",
                "SEARCH37.1",
                "SEARCH37.2",
                "SEARCH37.3",
                "SEARCH38.0",
                "SEARCH38.1",
                "SEARCH38.2",
                "SEARCH38.3",
                "SEARCH39",
                "SEARCH40",
                "SEARCH41",
                "SEARCH6.0",
                "SEARCH6.1",
                "SEARCH7.0",
                "SEARCH7.1",
                "SEARCH8.0",
                "SEARCH8.1",
                "SEARCH9.0",
                "SEARCH9.1",
                "SEARCH_FOL_NEW",
                "SEARCH_IVA_NEW",
                "SEARCH_MYT_NEW.0",
                "SEARCH_MYT_NEW.1",
                "SEARCH_MYT_NEW.2",
                "SEARCH_UGR_NEW",
                "TSNET_NIRVANA_SAS",
                "UGR-5.0",
                "UGR-5.1",
                "UGR-5.2",
                "UGR-5.3",
                "UGR-6.0",
                "UGR-7.0",
                "UGR-7.1",
                "UGR-7.2",
                "VIDEOS1",
                "VIDEOS24",
                "VIDEOS30",
                "VIDEOS33",
                "VIDEOS6",
                "VIDEOS7",
                "VIDEOS8",
                "VLA1.0",
                "VLA1.1",
                "VLA1.10",
                "VLA1.11",
                "VLA1.12",
                "VLA1.13",
                "VLA1.14",
                "VLA1.15",
                "VLA1.16",
                "VLA1.2",
                "VLA1.3",
                "VLA1.4",
                "VLA1.5",
                "VLA1.6",
                "VLA1.7",
                "VLA1.8",
                "VLA1.9",
                "VLA2.0",
                "YASM_ALERTSRV",
                "YASM_DEV",
                "YASM_FRONT_FOL",
                "YASM_FRONT_IVA",
                "YASM_FRONT_MYT",
                "YASM_FRONT_SAS",
                "YASM_FRONT_UGR",
                "YASM_PRESTABLE",
                "YASM_SRV_AMS",
                "YASM_SRV_FOL",
                "YASM_SRV_IVA",
                "YASM_SRV_MAIL",
                "YASM_SRV_MAN",
                "YASM_SRV_MYT",
                "YASM_SRV_SAS",
                "YASM_SRV_UGR"
            }
        },
        {
            "BS_FAST_TRAFFIC",
            {
                "BS_FAST_TRAFFIC_FOL",
                "BS_FAST_TRAFFIC_UGR"
            }
        },
        {
            "CMS", {"CMS",}
        },
        {
            "CON",
            {
                "CLUSTERAPI_C_SAS",
                "CLUSTERAPI_FOL",
                "CLUSTERAPI_R1_PROD_FOL",
                "CLUSTERAPI_R1_PROD_MYT",
                "CLUSTERAPI_R1_PROD_UGR",
                "CLUSTERAPI_R2_SAS",
                "CLUSTERAPI_UGR",
                "CON_CENTER.0",
                "CON_CENTER.0.0",
                "CON_CENTER.0.1",
                "CON_CENTER.1",
                "CON_CENTER.1.0",
                "CON_CENTER.1.1",
                "CON_CENTER.10",
                "CON_CENTER.10.0",
                "CON_CENTER.10.1",
                "CON_CENTER.11",
                "CON_CENTER.11.0",
                "CON_CENTER.11.1",
                "CON_CENTER.2",
                "CON_CENTER.2.0",
                "CON_CENTER.2.1",
                "CON_CENTER.3",
                "CON_CENTER.3.0",
                "CON_CENTER.3.1",
                "CON_CENTER.4",
                "CON_CENTER.4.0",
                "CON_CENTER.4.1",
                "CON_CENTER.5",
                "CON_CENTER.5.0",
                "CON_CENTER.5.1",
                "CON_CENTER.6",
                "CON_CENTER.6.0",
                "CON_CENTER.6.1",
                "CON_CENTER.7",
                "CON_CENTER.7.0",
                "CON_CENTER.7.1",
                "CON_CENTER.8",
                "CON_CENTER.8.0",
                "CON_CENTER.8.1",
                "CON_CENTER.9",
                "CON_CENTER.9.0",
                "CON_CENTER.9.1",
                "CON_EAST.0",
                "CON_EAST.1",
                "CON_EAST.2",
                "CON_SOUTH.0",
                "CON_SOUTH.1",
                "CON_SOUTH.10",
                "CON_SOUTH.10.0",
                "CON_SOUTH.10.1",
                "CON_SOUTH.11",
                "CON_SOUTH.11.0",
                "CON_SOUTH.11.1",
                "CON_SOUTH.2",
                "CON_SOUTH.3",
                "CON_SOUTH.4",
                "CON_SOUTH.5",
                "CON_SOUTH.6",
                "CON_SOUTH.7",
                "CON_SOUTH.8",
                "CON_SOUTH.8.0",
                "CON_SOUTH.8.1",
                "CON_SOUTH.9",
                "CON_SOUTH.9.0",
                "CON_SOUTH.9.1",
                "CON_WEST.0",
                "CON_WEST.1",
                "CON_WEST.2",
                "CON_WEST.3",
                "CON_WEST.4",
                "CON_WEST.5",
                "DISK_APIDB",
                "DISK_COMMENTSDB",
                "DISK_DISKQ_DB",
                "DISK_SMCDB",
                "MAIL_CORPDB",
                "MAIL_MISCDB",
                "MAIL_MISCDB_TEST",
                "MAIL_MOPSDB",
                "MAIL_PG_COMMON_QA",
                "MAIL_PG_COMMON_TEST",
                "MAIL_PG_STABLE_TEST",
                "MAIL_PGLOAD",
                "MAIL_PGMETA",
                "MAIL_PGMETA_COMMON_QA",
                "MAIL_PGPROXY_FOL",
                "MAIL_PGPROXY_IVA",
                "MAIL_PGPROXY_MYT",
                "MAIL_PGPROXY_SAS",
                "MAIL_PGPROXY_UGR",
                "MAIL_RPOPDB",
                "MAIL_S3DB",
                "MAIL_S3META",
                "MAIL_SETDB",
                "MAIL_SHARPEI",
                "MAIL_SHARPEI_LOAD",
                "MAIL_SHARPEI_TEST",
                "MAIL_XDB1",
                "MAIL_XDB_QA",
                "MAIL_XDB_TEST",
                "MAIL_XIVA_IVA",
                "MAIL_XIVA_MYT",
                "MAIL_XIVA_SAS",
                "MAIL_XIVADB",
                "MAIL_XIVASTORE",
                "MAILDISK1",
                "MAILDISKSYNC",
                "MAILDISKWEBDAV",
                "MAILDOCVIEWER",
                "MAILMULCA_LETO_IVA",
                "MAILMULCA_LETO_MYT",
                "MAILMULCA_LETO_SAS",
                "MAILMULCA_ZIMA_IVA",
                "MAILMULCA_ZIMA_MYT",
                "MAILMULCA_ZIMA_SAS",
                "MAILWEB_FOL",
                "MAILWEB_IVA",
                "MAILWEB_MYT",
                "MAILWEB_SAS",
                "MAILWEB_UGR",
                "MDB_DOM0",
                "MDB_MARKET",
                "MDB_OTHER",
                "MDB_PAYSYS",
                "MDS_PROXY_FOL",
                "MDS_PROXY_IVA",
                "MDS_PROXY_MAN",
                "MDS_PROXY_MYT",
                "MDS_PROXY_SAS",
                "MDS_PROXY_UGR",
                "MDS_PROXY_VLA",
                "PARALLELS",
                "PGAAS_PROXY_01",
                "PORTAL_STATIC_IVA",
                "PORTAL_STATIC_MAN",
                "PORTAL_STATIC_MYT",
                "PORTAL_STATIC_PRESTABLE_SAS",
                "PORTAL_STATIC_SAS",
                "PORTAL_STATIC_STABLE_IVA",
                "PORTAL_STATIC_STABLE_MAN",
                "PORTAL_STATIC_STABLE_MYT",
                "PORTAL_STATIC_STABLE_SAS",
                "PORTAL_STATIC_STABLE_UGR",
                "PORTAL_STATIC_TESTING_IVA",
                "PORTAL_STATIC_TESTING_SAS",
                "PORTAL_TUNE_PRESTABLE",
                "PORTAL_TUNE_STABLE_FOL",
                "PORTAL_TUNE_STABLE_MAN",
                "PORTAL_TUNE_STABLE_SAS",
                "PORTAL_WFRONT_PRESTABLE_SAS",
                "PORTAL_WFRONT_STABLE_FOL",
                "PORTAL_WFRONT_STABLE_IVA",
                "PORTAL_WFRONT_STABLE_MAN",
                "PORTAL_WFRONT_STABLE_MYT",
                "PORTAL_WFRONT_STABLE_SAS",
                "PORTAL_XIVA_PRESTABLE_SAS",
                "PORTAL_XIVA_STABLE_FOL",
                "PORTAL_XIVA_STABLE_IVA",
                "PORTAL_XIVA_STABLE_MYT",
                "PORTAL_XIVA_STABLE_SAS",
                "PROXY_AMS_1_3.3",
                "PROXY_AMS_1_4.9",
                "PROXY_ASH",
                "PROXY_EKT",
                "PROXY_EKTMTS",
                "PROXY_KHAB",
                "PROXY_KHABRT",
                "PROXY_KIEV",
                "PROXY_KRASMTS",
                "PROXY_KZ",
                "PROXY_MINSK",
                "PROXY_NNOV",
                "PROXY_NOVOSIBBLN",
                "PROXY_NOVOSIBIRSK",
                "PROXY_NOVOSIBMGF",
                "PROXY_NOVOSIBMTS",
                "PROXY_NOVOSIBRT",
                "PROXY_SAMARAMGF",
                "PROXY_SPB",
                "PROXY_STAV",
                "PROXY_TOMSKMGF",
                "PROXY_TURK",
                "PROXY_UFA",
                "PROXY_VLADMTS",
                "SPUTNIK_MON",
                "STORAGE_MULCAGATE_FOL",
                "STORAGE_MULCAGATE_IVA",
                "STORAGE_MULCAGATE_MAN",
                "STORAGE_MULCAGATE_MYT",
                "STORAGE_MULCAGATE_SAS",
                "STORAGE_MULCAGATE_UGR",
                "STORAGE_MULCAGATE_VLA",
                "TSNET_CAPI_SAS",
                "YABS_FRONTEND_FOL",
                "YABS_FRONTEND_IVA",
                "YABS_FRONTEND_MAN",
                "YABS_FRONTEND_MYT",
                "YABS_FRONTEND_SAS",
                "YABS_FRONTEND_UGR",
                "ZEN_STORAGE_SAS"
            }
        },
        {
            "DISTBUILD", {"DISTBUILD",}
        },
        {
            "DISTMASTER", {"DISTMASTER",}
        },
        {
            "ELLIPTICS",
            {
                "ELLIPTICS_PROXY_FOL",
                "ELLIPTICS_PROXY_MAN_OLD.2",
                "ELLIPTICS_PROXY_SAS",
                "ELLIPTICS_PROXY_UGR",
                "ELLIPTICS_PROXY_VLA"
            }
        },
        {
            "ELLIPTICS_ALL",
            {
                "ELLIPTICS_ALL_FOL",
                "ELLIPTICS_ALL_MAN_OLD.2",
                "ELLIPTICS_ALL_UGR",
                "ELLIPTICS_ALL_VLA"
            }
        },
        {
            "ELLIPTICS_CLOUD",
            {
                "ELLIPTICS_CLOUD_FOL",
                "ELLIPTICS_CLOUD_UGR"
            }
        },
        {
            "ELLIPTICS_STORAGE",
            {
                "ELLIPTICS_STORAGE_FOL",
                "ELLIPTICS_STORAGE_MAN_OLD.2",
                "ELLIPTICS_STORAGE_UGR"
            }
        },
        {
            "ELLIPTICS_STORAGE_PRESTABLE", {"ELLIPTICS_STORAGE_PRESTABLE_UGR",}
        },
        {
            "ELLIPTICS_STORAGE_TESTING",
            {
                "ELLIPTICS_STORAGE_TESTING_FOL",
                "ELLIPTICS_STORAGE_TESTING_MAN",
                "ELLIPTICS_STORAGE_TESTING_UGR",
            }
        },
        {
            "ELLIPTICS_TEST_ALL",
            {
                "ELLIPTICS_TEST_ALL_FOL",
                "ELLIPTICS_TEST_ALL_UGR",
            }
        },
        {
            "FAVICON",
            {
                "FOL_FAVICON_FAVICON",
                "IVA_FAVICON_FAVICON",
                "MSK_FAVICON_FAVICON",
                "MYT_FAVICON_FAVICON",
                "SAS_FAVICON_FAVICON",
                "UGR_FAVICON_FAVICON",
            }
        },
        {
            "FUSIONSTORE",
            {
                "FUSION_DISTRIBUTOR",
                "FUSIONSTORE_LEGACY",
            }
        },
        {
            "JUGGLER_BATCHER",
            {
                "JUGGLER_BATCHER_FOL",
                "JUGGLER_BATCHER_IVA",
                "JUGGLER_BATCHER_MAN",
                "JUGGLER_BATCHER_MYT",
                "JUGGLER_BATCHER_SAS",
                "JUGGLER_BATCHER_UGR",
            }
        },
        {
            "JUGGLER_SERVER",
            {
                "JUGGLER_SERVER_FOL",
                "JUGGLER_SERVER_IVA",
                "JUGGLER_SERVER_SAS",
                "JUGGLER_SERVER_UGR",
            }
        },
        {
            "JUGGLER_SERVER_DEVELOP", {"JUGGLER_SERVER_DEVELOP",}
        },
        {
            "MAIL_PG_TEST", {"MAIL_PGTEST",}
        },
        {
            "MAILMULCA",
            {
                "MAILMULCA1",
                "MAILMULCA_LETO",
                "MAILMULCA_ZIMA",
            }
        },
        {
            "MAILMXFRONT",
            {
                "MAILMXBACK",
                "MAILMXFRONT1",
                "MAILMXFRONT_FOL",
                "MAILMXFRONT_IVA",
                "MAILMXFRONT_MYT",
                "MAILMXFRONT_UGR",
            }
        },
        {
            "MAILSETTINGS",
            {
                "MAILSETTINGS_FOL",
                "MAILSETTINGS_HIST",
                "MAILSETTINGS_IVA",
                "MAILSETTINGS_MYT",
                "MAILSETTINGS_SAS",
                "MAILSETTINGS_UGR",
            }
        },
        {
            "MAILWEB", {"MAILWEB_HIST",}
        },
        {
            "META_NEWS8", {"META_NEWS8",}
        },
        {
            "MOBILE_API_LBS",
            {
                "MOBILE_API_LBS_FOL",
                "MOBILE_API_LBS_INT_FOL",
                "MOBILE_API_LBS_INT_MYT",
                "MOBILE_API_LBS_INT_SAS",
                "MOBILE_API_LBS_MYT",
                "MOBILE_API_LBS_SAS",
            }
        },
        {
            "MOBREPORT_MYSQL",
            {
                "MOBREPORT_DB",
                "MOBREPORT_TESTING",
            }
        },
        {
            "MSK_BALANCER_TEST", {"MSK_BALANCER_TEST",}
        },
        {
            "NEWS_AUX", {"NEWS_AUX",}
        },
        {
            "NEWS_IDX", {"NEWS_IDX",}
        },
        {
            "NEWS_IDX_DEV", {"NEWS_IDX_DEV",}
        },
        {
            "NOC_MON", {"NOC_MON_MYT",}
        },
        {
            "NSCACHE", {"NSCACHE_AMS",}
        },
        {
            "OXYGEN",
            {
                "OXYGEN_FOLA",
                "OXYGEN_SAS",
                "OXYGEN_UGRB",
            }
        },
        {
            "PORTAL_CLOP",
            {
                "PORTAL_CLOP_FOL",
                "PORTAL_CLOP_IVA",
                "PORTAL_CLOP_MYT",
                "PORTAL_CLOP_SAS",
            }
        },
        {
            "QA_AERO", {"QA_AERO_MAN",}
        },
        {
            "QLOUD",
            {
                "QLOUD_ELASTICSEARCH_IVA",
                "QLOUD_ELASTICSEARCH_UGR",
                "QLOUD_GOLOVAN_FOL",
                "QLOUD_GOLOVAN_FOL.0",
                "QLOUD_GOLOVAN_IVA",
                "QLOUD_GOLOVAN_IVA.0",
                "QLOUD_GOLOVAN_IVA.1",
                "QLOUD_GOLOVAN_IVA.2",
                "QLOUD_GOLOVAN_IVA.3",
                "QLOUD_GOLOVAN_IVA.4",
                "QLOUD_GOLOVAN_IVA.5",
                "QLOUD_GOLOVAN_IVA.5.0",
                "QLOUD_GOLOVAN_IVA.5.1",
                "QLOUD_GOLOVAN_IVA.6",
                "QLOUD_GOLOVAN_IVA.6.0",
                "QLOUD_GOLOVAN_IVA.6.1",
                "QLOUD_GOLOVAN_IVA.7",
                "QLOUD_GOLOVAN_IVA.7.0",
                "QLOUD_GOLOVAN_IVA.7.1",
                "QLOUD_GOLOVAN_MAN",
                "QLOUD_GOLOVAN_MAN.0",
                "QLOUD_GOLOVAN_MAN.1",
                "QLOUD_GOLOVAN_MAN.2",
                "QLOUD_GOLOVAN_MAN_OLD.2.0",
                "QLOUD_GOLOVAN_MAN_OLD.2.1",
                "QLOUD_GOLOVAN_MYT",
                "QLOUD_GOLOVAN_MYT.0",
                "QLOUD_GOLOVAN_MYT.1",
                "QLOUD_GOLOVAN_MYT.2",
                "QLOUD_GOLOVAN_MYT.3",
                "QLOUD_GOLOVAN_MYT.4",
                "QLOUD_GOLOVAN_MYT.5",
                "QLOUD_GOLOVAN_MYT.6",
                "QLOUD_GOLOVAN_MYT.7",
                "QLOUD_GOLOVAN_SAS.0",
                "QLOUD_GOLOVAN_SAS.1",
                "QLOUD_GOLOVAN_SAS.10",
                "QLOUD_GOLOVAN_SAS.10.0",
                "QLOUD_GOLOVAN_SAS.10.1",
                "QLOUD_GOLOVAN_SAS.11",
                "QLOUD_GOLOVAN_SAS.11.0",
                "QLOUD_GOLOVAN_SAS.11.1",
                "QLOUD_GOLOVAN_SAS.2",
                "QLOUD_GOLOVAN_SAS.3",
                "QLOUD_GOLOVAN_SAS.4",
                "QLOUD_GOLOVAN_SAS.5",
                "QLOUD_GOLOVAN_SAS.6",
                "QLOUD_GOLOVAN_SAS.7",
                "QLOUD_GOLOVAN_SAS.8",
                "QLOUD_GOLOVAN_SAS.8.0",
                "QLOUD_GOLOVAN_SAS.8.1",
                "QLOUD_GOLOVAN_SAS.9",
                "QLOUD_GOLOVAN_SAS.9.0",
                "QLOUD_GOLOVAN_SAS.9.1",
                "QLOUD_GOLOVAN_SAS_1",
                "QLOUD_GOLOVAN_UGR",
                "QLOUD_GOLOVAN_UGR.0",
                "QLOUD_GOLOVAN_VLA.0",
                "QLOUD_IVA.0",
                "QLOUD_IVA.1",
                "QLOUD_MYT.0",
                "QLOUD_MYT.1",
                "QLOUD_OTHER_IVA.0",
                "QLOUD_OTHER_IVA.1",
                "QLOUD_OTHER_MYT.0",
                "QLOUD_OTHER_MYT.1",
                "QLOUD_ROUTER_IVA.0",
                "QLOUD_ROUTER_IVA.1",
                "QLOUD_ROUTER_IVA.2",
                "QLOUD_ROUTER_MYT.0",
                "QLOUD_ROUTER_MYT.1",
                "QLOUD_ROUTER_MYT.2",
                "QLOUD_ROUTER_MYT.3",
                "QLOUD_SAS1_PRODUCTION",
                "QLOUD_UDPBL_FOL",
            }
        },
        {
            "QUICK", {"QUICK",}
        },
        {
            "RESIZER",
            {
                "RESIZER_PROXY_FOL",
                "RESIZER_PROXY_IVA",
                "RESIZER_PROXY_MYT",
                "RESIZER_PROXY_SAS",
                "RESIZER_PROXY_UGR",
            }
        },
        {
            "RTMR", {"RTMR_MAN",}
        },
        {
            "SBALANCER",
            {
                "AMS1_SBALANCER",
                "MAN_SERVICE_BALANCER",
                "SAS1_SBALANCER",
                "SERVICE_BALANCER",
                "SERVICE_BALANCER2",
                "SERVICE_BALANCER5",
                "SERVICE_BALANCER6",
                "SERVICE_BALANCER7",
                "SERVICE_BALANCER8",
                "SERVICE_BALANCER9",
            }
        },
        {
            "SBALANCER_MSK", {"SERVICE_BALANCER6"}
        },
        {
            "SEARCH_DEV_TSNET_YASM", {"SEARCH_DEV_TSNET_YASM_SAS"}
        },
        {
            "SG", {"SG"}
        },
        {
            "STORAGE_SRW",
            {
                "STORAGE_SRW_FOL",
                "STORAGE_SRW_UGR",
            }
        },
        {
            "STORAGE_TEST_SRW",
            {
                "STORAGE_TEST_SRW_FOL",
                "STORAGE_TEST_SRW_UGR",
            }
        },
        {
            "TESTWS_FOL", {"TESTWS_FOL",}
        },
        {
            "WAF_INT",
            {
                "WAF_INT_FOL",
                "WAF_INT_SAS",
                "WAF_INT_UGR",
            }
        },
        {
            "YALITE_RUS",
            {
                "MAN_WEB_RUS_YALITE",
                "MSK_WEB_RUS_YALITE",
                "SAS_WEB_RUS_YALITE",
            }
        },
        {
            "YALITE_TUR",
            {
                "MAN_WEB_TUR_YALITE",
                "MSK_WEB_TUR_YALITE",
                "SAS_WEB_TUR_YALITE",
            }
        },
        {
            "YASM_LINES",
            {
                "YASM_LINE_FOL",
                "YASM_LINE_MYT",
                "YASM_LINE_SAS",
            }
        },
        {
            "YASM_STORE",
            {
                "YASM_STORE_FOL",
                "YASM_STORE_IVA",
                "YASM_STORE_MYT",
                "YASM_STORE_UGR",
            }
        },
        {
            "YLITE", {"YLITE"}
        },
        {
            "ZEN_STORAGE", {"ZEN_STORAGE_FOL"}
        },
        {
            "ZEN_STORAGE_PRESTABLE", {"ZEN_STORAGE_PRESTABLE_FOL"}
        },
    };
    for (auto& [metagroup, groups] : historyGroups) {
        auto metagroupIt = result.find(metagroup);
        if (metagroupIt == result.end()) {
            result.emplace(metagroup, groups);
        } else {
            metagroupIt->second.reserve(metagroupIt->second.size() + groups.size());
            metagroupIt->second.insert(metagroupIt->second.end(), groups.begin(), groups.end());
        }
    }
    return result;
}

} // namespace

NYasm::NGroups::TMetagroupGroupsConfig::TMetagroupGroupsConfig()
    : MetagroupToGroupsListProdMap(MakeMetagroupToGroupsListProdMap())
    , MetagroupToGroupsListProdWithHistNodesMap(MakeMetagroupToGroupsListProdWIthHistNodesMap())
    , MetagroupToGroupsListPrestableMap(MakeMetagroupToGroupsListPrestableMap()) {
}

TMetagroupGroupsConfig::TMetagroupGroupsConfig(THashMap<TString, TVector<TString>> metagroupsMap)
    : MetagroupToGroupsListProdMap(std::move(metagroupsMap))
    , MetagroupToGroupsListProdWithHistNodesMap(MetagroupToGroupsListProdMap)
    , MetagroupToGroupsListPrestableMap() {
}
} // namespace NYasm::NGroups
