#pragma once

#include <util/generic/fwd.h>
#include <util/generic/vector.h>
#include <util/generic/hash.h>


namespace NYasm::NGroups {

    /* Implemented as a class to allow loading from file in the future */
    class TMetagroupGroupsConfig {
    public:
        TMetagroupGroupsConfig();

        /**
         * Construct group config explicitly specified metagroup maps
         */
        explicit TMetagroupGroupsConfig(THashMap<TString, TVector<TString>> metagroupsMap);

        const THashMap<TString, TVector<TString>>& GetMetagroupToGroupsListProdMap(bool includeHistNodes = false) const {
            if (includeHistNodes) {
                return MetagroupToGroupsListProdWithHistNodesMap;
            } else {
                return MetagroupToGroupsListProdMap;
            }
        }
        const THashMap<TString, TVector<TString>>& GetMetagroupToGroupsListPrestableMap() const {
            return MetagroupToGroupsListPrestableMap;
        }
    private:
        THashMap<TString, TVector<TString>> MetagroupToGroupsListProdMap;
        THashMap<TString, TVector<TString>> MetagroupToGroupsListProdWithHistNodesMap;
        THashMap<TString, TVector<TString>> MetagroupToGroupsListPrestableMap;
    };
}
