#pragma once

#include "const.h"

#include <util/datetime/base.h>

namespace NYasm::NCommon::NInterval {

    inline static TInstant NormalizeToIntervalUp(TInstant timestamp, TDuration interval = ITERATION_SIZE) {
        auto offset = TDuration::FromValue(timestamp.GetValue() % interval.GetValue());
        return offset == TDuration::Zero() ? timestamp : timestamp + interval - offset;
    }

    inline static TInstant NormalizeToIntervalDown(TInstant timestamp, TDuration interval = ITERATION_SIZE) {
        return timestamp - TDuration::FromValue(timestamp.GetValue() % interval.GetValue());
    }

    inline static TInstant GetCurrentIterationStart() {
        return NormalizeToIntervalDown(TInstant::Now());
    }

}
