#pragma once

#include <infra/yasm/common/labels/signal/cache.h>

#include <util/string/ascii.h>
#include <util/generic/algorithm.h>

#include <span>

namespace NZoom::NHost {
    class THostRef {
    public:
        THostRef(TStringBuf name);

        const TString& GetName() const noexcept;
        bool IsGroup() const noexcept;

    protected:
        const TString Name;
        const bool GroupFlag;
    };

    class THostName {
    public:
        THostName();
        THostName(const TString& name);
        THostName(TStringBuf name);

        static TVector<THostName> CreateMany(std::span<const TString* const> names);

        const TString& GetName() const noexcept;
        bool IsGroup() const noexcept;
        bool Empty() const noexcept;

        inline bool operator == (const THostName& other) const noexcept {
            return Impl == other.Impl;
        }

        inline bool operator != (const THostName& other) const noexcept {
            return !operator==(other);
        }

        bool operator < (const THostName& other) const noexcept {
            return Impl < other.Impl;
        }

        inline size_t Hash() const noexcept {
            return reinterpret_cast<size_t>(Impl);
        }

    private:
        THostName(const THostRef* impl);

        const THostRef* Impl = nullptr;
    };
}

template<>
struct THash<NZoom::NHost::THostName> {
    inline size_t operator()(const NZoom::NHost::THostName& v) const noexcept {
        return v.Hash();
    }
};
