#include <infra/yasm/common/labels/host/host.h> // Prevent clash with system headers

#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NHost;

Y_UNIT_TEST_SUITE(TZoomHostsTest) {

    Y_UNIT_TEST(TestIntern) {
        THostName h1(TStringBuf("abcd"));
        THostName h2(TString::Join("abc", 'd'));
        UNIT_ASSERT_EQUAL(h1.Hash(), h2.Hash());
        UNIT_ASSERT_EQUAL(h1, h2);
    }

    Y_UNIT_TEST(TestHash) {
        THostName h1(TStringBuf("abcd"));
        THashMap<THostName, TString> map;
        map.emplace(h1, "a");
        THostName h2(TString::Join("ab", "cd"));
        UNIT_ASSERT_EQUAL(map.at(h2), "a");
    }

    Y_UNIT_TEST(TestGroup) {
        THostName host(TStringBuf("sas1-1234.search.yandex.net"));
        UNIT_ASSERT(!host.IsGroup());

        THostName group(TStringBuf("SAS_KERNEL.000"));
        UNIT_ASSERT(group.IsGroup());
    }

    Y_UNIT_TEST(TestCreateMany) {
        TVector<TString> names{"sas1-1234", "sas2-2345"};
        TVector<THostName> hosts = THostName::CreateMany(TVector{&names[0], &names[1]});
        UNIT_ASSERT_VALUES_EQUAL(hosts.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(hosts.at(0), THostName(TStringBuf("sas1-1234")));
        UNIT_ASSERT_VALUES_EQUAL(hosts.at(1), THostName(TStringBuf("sas2-2345")));

        TVector<TString> otherNames{"sas3-3456", "sas2-2345"};
        TVector<THostName> otherHosts = THostName::CreateMany(TVector{&otherNames[0], &otherNames[1]});
        UNIT_ASSERT_VALUES_EQUAL(otherHosts.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(otherHosts.at(0), THostName(TStringBuf("sas3-3456")));
        UNIT_ASSERT_VALUES_EQUAL(otherHosts.at(1), THostName(TStringBuf("sas2-2345")));
    }

    Y_UNIT_TEST(TestEmpty) {
        THostName nonEmptyHost(TStringBuf("sas1-1234.search.yandex.net"));
        UNIT_ASSERT(!nonEmptyHost.Empty());

        THostName firstEmptyHost;
        UNIT_ASSERT(firstEmptyHost.Empty());

        THostName secondEmptyHost;
        UNIT_ASSERT(secondEmptyHost.Empty());

        UNIT_ASSERT_VALUES_UNEQUAL(nonEmptyHost, firstEmptyHost);
        UNIT_ASSERT_VALUES_EQUAL(firstEmptyHost, secondEmptyHost);
    }
}
