#include "cache.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NSignal;

Y_UNIT_TEST_SUITE(TZoomSignalsCacheTest) {
    struct TItem : public TNonCopyable {
        TString Item;


        TItem(const TString& item)
            : Item(item)
        {
        }

        TItem(TItem&& other)
            : Item(std::move(other.Item))
        {
        }

        const TString& GetName() const noexcept {
            return Item;
        }
    };

    Y_UNIT_TEST(TestIntern) {
        TCache<TItem> cache;
        UNIT_ASSERT_VALUES_EQUAL(cache.Get(""), nullptr);
        const TItem* p1 = cache.Insert(TItem("ab"));
        const TItem* p2 = cache.Get("ab");
        UNIT_ASSERT_VALUES_EQUAL(p1, p2);
        UNIT_ASSERT_VALUES_EQUAL(p1->Item, "ab");
    }

    Y_UNIT_TEST(TestMany) {
        TCache<TItem> cache;
        {
            TCache<TItem>::TReader reader(&cache);
            UNIT_ASSERT_VALUES_EQUAL(reader.Get("ab"), nullptr);
        }
        {
            TCache<TItem>::TWriter writer(&cache);
            UNIT_ASSERT(writer.Insert(TItem("ab")));
        }
        {
            TCache<TItem>::TReader reader(&cache);
            UNIT_ASSERT_VALUES_EQUAL(reader.Get("ab")->Item, "ab");
        }
    }
}
