#pragma once

#include <infra/yasm/common/labels/signal/cache.h>
#include <infra/yasm/common/points/accumulators/types/accumulators_types.h>

#include <util/generic/maybe.h>
#include <util/generic/ptr.h>

#include <span>

namespace NZoom {
    namespace NSignal {

        bool IsValidSignalName(const TString& signalNameWithPrefix);

        class TAbstractSignalRef {
        protected:
            TString Name;

        public:
            TAbstractSignalRef(TString name);
            virtual ~TAbstractSignalRef() = default;
            const TString& GetName() const noexcept;
            virtual bool IsOld() const noexcept = 0;
            virtual const NZoom::NAccumulators::TAggregationRules* GetAggregationRules() const noexcept = 0;
        };

        class TSignalName {
        private:
            const TAbstractSignalRef* Impl = nullptr;

            TSignalName(const TAbstractSignalRef* impl);

        public:
            TSignalName(const TString& name);
            TSignalName(TStringBuf name);

            static TMaybe<TSignalName> TryNew(const TString& name);
            static TVector<TSignalName> CreateMany(std::span<const TString* const> names);

            const TString& GetName() const noexcept;
            bool IsOld() const noexcept;

            inline bool operator == (const TSignalName& other) const noexcept {
                return Impl == other.Impl;
            }

            bool operator < (const TSignalName& other) const noexcept {
                return Impl < other.Impl;
            }

            inline size_t Hash() const noexcept {
                return THash<TAbstractSignalRef*>()(Impl);
            }

            const NZoom::NAccumulators::TAggregationRules* GetAggregationRules() const noexcept;
            TMaybe<NZoom::NAccumulators::EAccumulatorType> GetAggregationType(NZoom::NAccumulators::EAggregationMethod method) const;
        };
    }
}

template<>
struct THash<NZoom::NSignal::TSignalName> {
    inline size_t operator()(const NZoom::NSignal::TSignalName& v) const noexcept {
        return v.Hash();
    }
};
