#include "signal_name.h"

#include <library/cpp/testing/unittest/registar.h>

#include <array>

using namespace NZoom::NSignal;

Y_UNIT_TEST_SUITE(TZoomSignalsTest) {

    Y_UNIT_TEST(TestIntern) {
        TSignalName s1(TStringBuf("abcd"));
        TSignalName s2(TString::Join("abc", 'd'));
        UNIT_ASSERT_EQUAL(s1.Hash(), s2.Hash());
        UNIT_ASSERT_EQUAL(s1, s2);
    }

    Y_UNIT_TEST(TestIntern2) {
        TSignalName s1(TStringBuf("abcd_axxx"));
        TSignalName s2(TString::Join("abcd", '_', "axxx"));
        UNIT_ASSERT_EQUAL(s1.Hash(), s2.Hash());
        UNIT_ASSERT_EQUAL(s1, s2);
    }

    Y_UNIT_TEST(TestHash) {
        TSignalName s1(TStringBuf("abcd_axxx"));
        THashMap<TSignalName, TString> map;
        map.emplace(s1, "a");
        TSignalName s2(TString::Join("abcd", '_', "axxx"));
        UNIT_ASSERT_EQUAL(map.at(s2), "a");
    }

    Y_UNIT_TEST(TestCreateMany) {
        TVector<TString> names{"abcd", "abcd_axxx"};
        TVector<TSignalName> signals = TSignalName::CreateMany(TVector{&names[0], &names[1]});
        UNIT_ASSERT_VALUES_EQUAL(signals.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(signals.at(0), TSignalName(TStringBuf("abcd")));
        UNIT_ASSERT_VALUES_EQUAL(signals.at(1), TSignalName(TStringBuf("abcd_axxx")));

        TVector<TString> otherNames{"abcd_summ", "abcd_axxx"};
        TVector<TSignalName> otherSignals = TSignalName::CreateMany(TVector{&otherNames[0], &otherNames[1]});
        UNIT_ASSERT_VALUES_EQUAL(otherSignals.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(otherSignals.at(0), TSignalName(TStringBuf("abcd_summ")));
        UNIT_ASSERT_VALUES_EQUAL(otherSignals.at(1), TSignalName(TStringBuf("abcd_axxx")));
    }

    Y_UNIT_TEST(SignalNameValidation) {
        UNIT_ASSERT(IsValidSignalName("unistat-signal_summ"));
        UNIT_ASSERT(IsValidSignalName("unistat-signal1_mmmm"));
        UNIT_ASSERT(IsValidSignalName("unistat-@signal_hgram"));
        UNIT_ASSERT(IsValidSignalName("unistat-/signal_hgram"));
        UNIT_ASSERT(IsValidSignalName("unistat-SIGNAL_hgram"));

        // invalid characters
        UNIT_ASSERT(!IsValidSignalName("unistat-\\signal_summ"));
        UNIT_ASSERT(!IsValidSignalName("unistat-%signal%_summ"));
        UNIT_ASSERT(!IsValidSignalName("unistat-$signal_summ"));
        UNIT_ASSERT(!IsValidSignalName("$unistat-signal_summ"));
        UNIT_ASSERT(!IsValidSignalName("unistat-verylongsignal_verylongsignal_verylongsignal_verylongsignal_verylongsignal_verylongsignal_verylongsignal_verylongsignal_summ"));

        // forbidden aggregation types
        UNIT_ASSERT(!IsValidSignalName("unistat-signal_avvx"));
        UNIT_ASSERT(!IsValidSignalName("unistat-signal_avvt"));
        UNIT_ASSERT(!IsValidSignalName("unistat-signal_avvn"));
        UNIT_ASSERT(!IsValidSignalName("unistat-signal_xvvt"));
        UNIT_ASSERT(!IsValidSignalName("unistat-signal_xvvn"));
        UNIT_ASSERT(!IsValidSignalName("unistat-signal_nvvn"));
    }
}
