#include "dynamic_filter.h"

#include <util/generic/xrange.h>
#include <util/generic/maybe.h>

using namespace NTags;
using namespace NTags::NPrivate;

const TGroup& TDynamicFilter::SelectBestGroup(const TAggregatedGroups& aggregatedGroups) const {
    const TAggregatedGroups::value_type* bestGroup = nullptr;
    for (const auto& group: aggregatedGroups) {
        if (!bestGroup) {
            bestGroup = &group;
        } else if (bestGroup->first.size() != group.first.size()) {
            // prefer bigger aggregated part
            bestGroup = (bestGroup->first.size() > group.first.size()) ? bestGroup : &group;
        } else {
            if (bestGroup->second.size() != group.second.size()) {
                // prefer smaller number of keys
                bestGroup = (bestGroup->second.size() < group.second.size()) ? bestGroup : &group;
            } else {
                // deterministically choose any of the two groups
                using THashFunc = THash<TAggregated>;
                bestGroup = (THashFunc()(bestGroup->first) < THashFunc()(group.first)) ? bestGroup : &group;
            }
        }
    }
    Y_VERIFY(bestGroup);
    return bestGroup->second;
}

bool TDynamicFilter::Feed(TInstanceKey instanceKey, bool exactMatch) {
    if (RequestKey && !RequestKey->Match(instanceKey, exactMatch)) {
        return false;
    }
    TagSetGroups[instanceKey.GetTagsAndAggregatedNameSet()][instanceKey.GetAggregated()].push_back(instanceKey);
    return true;
}

TVector<TInstanceKey> TDynamicFilter::Resolve() const {
    TVector<TInstanceKey> result;

    for (const auto& [tagsNames, aggregatedGroups] : TagSetGroups) {
        const auto& bestGroup = SelectBestGroup(aggregatedGroups);
        std::copy(bestGroup.begin(), bestGroup.end(), std::back_inserter(result));
    }

    return result;
}
