#pragma once

#include <infra/yasm/common/labels/tags/instance_key.h>
#include <infra/yasm/common/labels/tags/request_key.h>

namespace NTags {
    using TGroup = TVector<TInstanceKey>;
    using TAggregatedGroups = THashMap<NPrivate::TAggregated, TGroup>;
    using TTagSetGroups = THashMap<TInternedTagNameSet, TAggregatedGroups>;

    class TDynamicFilter {
    public:
        /**
         * Default constructor for cases when request key matching is not needed (keys were pre-matched externally).
         */
        TDynamicFilter()
            : RequestKey(nullptr)
        {
        }

        explicit TDynamicFilter(const TRequestKey& requestKey)
            : RequestKey(&requestKey)
        {
        }

        /**
         * Feed instance key into the filer.
         * @param instanceKey
         * @param exactMatch accept only keys with exactly the same tags
         * @return true if instance key was accepted (matched by the provided request key).
         *         If no request key was provided on dynamic filter construction the all instance keys are accepted.
         */
        bool Feed(TInstanceKey instanceKey, bool exactMatch = false);

        template <class TContainer>
        void FeedMany(const TContainer& instanceKeys) {
            for (const auto& instanceKey : instanceKeys) {
                Feed(instanceKey);
            }
        }

        TVector<TInstanceKey> Resolve() const;

        const TRequestKey* GetRequestKey() const noexcept {
            return RequestKey;
        }

    private:
        const TGroup& SelectBestGroup(const TAggregatedGroups& aggregatedGroups) const;

        const TRequestKey* RequestKey;
        TTagSetGroups TagSetGroups;
    };
}
