#include "interned_tag_name_set.h"

using namespace NTags;
using namespace NTags::NPrivate;

TTagNameSetStorage::TTagNameSetStorage() {
}

TTagNameSetStorage& TTagNameSetStorage::Instance() {
    static TTagNameSetStorage self;
    return self;
}

const TTagNameSet* TTagNameSetStorage::Get(const TTagNameSet& tagNameSet) {
    {
        TLightReadGuard rg(Mutex);
        const auto it = Storage.find(tagNameSet);
        if (it != Storage.end()) {
            return &(*it);
        }
    }

    TLightWriteGuard wg(Mutex);

    TIndex::insert_ctx ctx;
    auto it = Storage.find(tagNameSet, ctx);
    if (it != Storage.end()) {
        return &(*it);
    }

    it = Storage.emplace_direct(ctx, tagNameSet);
    return &(*it);
}
