#pragma once

#include <infra/yasm/common/labels/tags/tag_name_set.h>

namespace NTags {
    namespace NPrivate {
        class TTagNameSetStorage : public TNonCopyable {
        private:
            using TIndex = THashSet<TTagNameSet>;

        public:
            static TTagNameSetStorage& Instance();

            const TTagNameSet* Get(const TTagNameSet& tagNameSet);

        private:
            TTagNameSetStorage();

            TLightRWLock Mutex;
            THashSet<TTagNameSet> Storage;
        };
    }

    class TInternedTagNameSet {
    public:
        TInternedTagNameSet()
            : TInternedTagNameSet(TTagNameSet())
        {
        }

        TInternedTagNameSet(const TTagNameSet* impl)
            : Impl(impl)
        {
        }

        TInternedTagNameSet(const TTagNameSet& tagNameSet)
            : TInternedTagNameSet(NPrivate::TTagNameSetStorage::Instance().Get(tagNameSet))
        {
        }

        TInternedTagNameSet(const TVector<TStringBuf>& tagNames)
            : TInternedTagNameSet(TTagNameSet(tagNames))
        {
        }

        const TVector<TTagName>& GetOrdered() const noexcept {
            return Impl->GetOrdered();
        }

        bool Has(const TTagName& tagName) const noexcept {
            return Impl->Has(tagName);
        }

        bool IsSuperSet(const TInternedTagNameSet& other) const noexcept {
            return Impl->IsSuperSet(*other.Impl);
        }

        size_t Hash() const noexcept {
            return reinterpret_cast<size_t>(Impl);
        }

        bool operator==(const TInternedTagNameSet& other) const noexcept {
            return Impl == other.Impl;
        }

    private:
        const TTagNameSet* Impl;
    };
}

template <>
struct THash<NTags::TInternedTagNameSet> {
    inline size_t operator()(const NTags::TInternedTagNameSet& v) const noexcept {
        return v.Hash();
    }
};
