#include "tag_name.h"

using namespace NTags;
using namespace NTags::NPrivate;

namespace {
    // needed for proper ordering in tests
    static const TTagName INTERNED_ITYPE_TAG(ITYPE_TAG);
    static const TTagName INTERNED_CTYPE_TAG(CTYPE_TAG);
    static const TTagName INTERNED_PRJ_TAG(PRJ_TAG);
    static const TTagName INTERNED_GEO_TAG(GEO_TAG);
    static const TTagName INTERNED_TIER_TAG(TIER_TAG);
    static const TTagName INTERNED_GROUP_TAG(GROUP_TAG);
    static const TTagName INTERNED_HOST_TAG(HOST_TAG);
}

TTagNameStorage::TTagNameStorage() {
}

TTagNameStorage& TTagNameStorage::Instance() {
    static TTagNameStorage self;
    return self;
}

size_t TTagNameStorage::Get(TStringBuf tagName) {
    {
        TLightReadGuard rg(Mutex);
        const auto it = Storage.find(tagName);
        if (it != Storage.end()) {
            return it->second;
        }
    }

    TLightWriteGuard wg(Mutex);

    TIndex::insert_ctx ctx;
    auto it = Storage.find(tagName, ctx);
    if (it != Storage.end()) {
        return it->second;
    }

    it = Storage.emplace_direct(ctx, tagName, Storage.size());
    Names.emplace_back(it->first);
    return it->second;
}

TStringBuf TTagNameStorage::GetName(size_t index) {
    Y_VERIFY(index < Names.size());
    TLightReadGuard rg(Mutex);
    return Names[index];
}
