#pragma once

#include <library/cpp/threading/light_rw_lock/lightrwlock.h>

#include <util/generic/string.h>
#include <util/generic/hash.h>
#include <util/generic/vector.h>

namespace NTags {
    namespace NPrivate {
        static constexpr TStringBuf SELF(TStringBuf("self"));
        static constexpr TStringBuf ITYPE_TAG(TStringBuf("itype"));
        static constexpr TStringBuf CTYPE_TAG(TStringBuf("ctype"));
        static constexpr TStringBuf PRJ_TAG(TStringBuf("prj"));
        static constexpr TStringBuf GEO_TAG(TStringBuf("geo"));
        static constexpr TStringBuf TIER_TAG(TStringBuf("tier"));
        static constexpr TStringBuf GROUP_TAG(TStringBuf("group"));
        static constexpr TStringBuf HOST_TAG(TStringBuf("host"));
        static constexpr TStringBuf YASM_CONTAINER_TAG(TStringBuf("yasm_container"));

        class TTagNameStorage : public TNonCopyable {
        private:
            using TIndex = THashMap<TString, size_t>;

        public:
            static TTagNameStorage& Instance();

            size_t Get(TStringBuf tagName);
            TStringBuf GetName(size_t index);

        private:
            TTagNameStorage();

            TLightRWLock Mutex;
            TIndex Storage;
            TVector<TStringBuf> Names;
        };
    };

    class TTagName {
    public:
        TTagName()
            : Index(Max<size_t>())
        {
        }

        TTagName(size_t index)
            : Index(index)
        {
        }

        TTagName(TStringBuf tagName)
            : TTagName(NPrivate::TTagNameStorage::Instance().Get(tagName))
        {
        }

        size_t GetIndex() const noexcept {
            return Index;
        }

        TStringBuf GetName() const noexcept {
            return NPrivate::TTagNameStorage::Instance().GetName(Index);
        }

        size_t Hash() const noexcept {
            return static_cast<size_t>(Index);
        }

        bool operator==(const TTagName& other) const noexcept {
            return Index == other.Index;
        }

        bool operator!=(const TTagName& other) const noexcept {
            return Index != other.Index;
        }

        bool operator<(const TTagName& other) const noexcept {
            return Index < other.Index;
        }

    private:
        size_t Index;
    };
}

template <>
struct THash<NTags::TTagName> {
    inline size_t operator()(const NTags::TTagName& v) const noexcept {
        return v.Hash();
    }
};
