#include "tag_name_set.h"

#include <util/generic/algorithm.h>

using namespace NTags;

namespace {
    using namespace NTags::NPrivate;

    TVector<TTagName> CreateInternedTagNames(const TVector<TStringBuf>& tagNames) {
        TVector<TTagName> internedTagNames;
        internedTagNames.reserve(tagNames.size());
        for (const auto& name : tagNames) {
            internedTagNames.emplace_back(name);
        }
        return internedTagNames;
    }
}

TTagNameSet::TTagNameSet() {
}

TTagNameSet::TTagNameSet(const TVector<TTagName>& tagNames)
    : TagNames(tagNames.begin(), tagNames.end())
{
    OrderedTagNames.reserve(OrderedTagNames.size());
    OrderedTagNames.insert(OrderedTagNames.end(), TagNames.begin(), TagNames.end());
    Sort(OrderedTagNames);
}

TTagNameSet::TTagNameSet(const TVector<TStringBuf>& tagNames)
    : TTagNameSet(CreateInternedTagNames(tagNames))
{
}

bool TTagNameSet::IsSuperSet(const TTagNameSet& other) const noexcept {
    if (TagNames.size() < other.TagNames.size()) {
        return false;
    }
    for (const auto& otherTag : other.TagNames) {
        if (!TagNames.contains(otherTag)) {
            return false;
        }
    }
    return true;
}

size_t TTagNameSet::Hash() const noexcept {
    size_t result = 0;
    for (const auto& name : OrderedTagNames) {
        result = CombineHashes(result, THash<TTagName>()(name));
    }
    return result;
}
