#pragma once

#include <infra/yasm/common/labels/tags/tag_name.h>

#include <util/generic/hash_set.h>
#include <util/generic/array_ref.h>
#include <util/generic/vector.h>

namespace NTags {
    class TTagNameSet {
    public:
        TTagNameSet();

        TTagNameSet(const TVector<TTagName>& tagNames);

        TTagNameSet(const TVector<TStringBuf>& tagNames);

        bool Has(const TTagName& tagName) const noexcept {
            return TagNames.contains(tagName);
        }

        // ordered by tag appearance, not by alphabet
        const TVector<TTagName>& GetOrdered() const noexcept {
            return OrderedTagNames;
        }

        bool IsSuperSet(const TTagNameSet& other) const noexcept;

        size_t Hash() const noexcept;

        bool operator==(const TTagNameSet& other) const noexcept {
            return OrderedTagNames == other.OrderedTagNames;
        }

    private:
        THashSet<TTagName> TagNames;
        TVector<TTagName> OrderedTagNames;
    };
}

template <>
struct THash<NTags::TTagNameSet> {
    inline size_t operator()(const NTags::TTagNameSet& v) const noexcept {
        return v.Hash();
    }
};
