#include "tag_name_set.h"
#include "interned_tag_name_set.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NTags;

Y_UNIT_TEST_SUITE(TTagNameSetTest) {

    Y_UNIT_TEST(TestCompare) {
        TTagNameSet s1(TVector<TStringBuf>{TStringBuf("service"), TStringBuf("group")});
        TTagNameSet s2(TVector<TStringBuf>{TStringBuf("group"), TStringBuf("service")});
        TTagNameSet s3(TVector<TStringBuf>{TStringBuf("group"), TStringBuf("service"), TStringBuf("nanny")});
        UNIT_ASSERT_EQUAL(s1.Hash(), s2.Hash());
        UNIT_ASSERT_EQUAL(s1, s2);
        UNIT_ASSERT_UNEQUAL(s1, s3);
    }

    Y_UNIT_TEST(TestHas) {
        TTagNameSet set(TVector<TStringBuf>{TStringBuf("service"), TStringBuf("group")});
        UNIT_ASSERT(set.Has(TStringBuf("service")));
        UNIT_ASSERT(!set.Has(TStringBuf("srv")));
    }

    Y_UNIT_TEST(TestSuperSet) {
        TTagNameSet s1(TVector<TStringBuf>{TStringBuf("service"), TStringBuf("group")});
        TTagNameSet s2(TVector<TStringBuf>{TStringBuf("group"), TStringBuf("service")});
        TTagNameSet s3(TVector<TStringBuf>{TStringBuf("group"), TStringBuf("service"), TStringBuf("nanny")});
        UNIT_ASSERT(s1.IsSuperSet(s2));
        UNIT_ASSERT(s2.IsSuperSet(s1));
        UNIT_ASSERT(s3.IsSuperSet(s1));
        UNIT_ASSERT(!s1.IsSuperSet(s3));
    }

    Y_UNIT_TEST(TestOrder) {
        TVector<TTagName> rawNames{TStringBuf("group"), TStringBuf("service")};
        TTagNameSet nameSet(rawNames);
        UNIT_ASSERT_EQUAL(rawNames, nameSet.GetOrdered());
    }
}

Y_UNIT_TEST_SUITE(TInternedTagNameSetTest) {

    Y_UNIT_TEST(TestIntern) {
        TInternedTagNameSet s1(TTagNameSet(TVector<TStringBuf>{TStringBuf("service"), TStringBuf("group")}));
        TInternedTagNameSet s2(TTagNameSet(TVector<TStringBuf>{TStringBuf("group"), TStringBuf("service")}));
        TInternedTagNameSet s3(TTagNameSet(TVector<TStringBuf>{TStringBuf("group"), TStringBuf("service"), TStringBuf("nanny")}));
        UNIT_ASSERT_EQUAL(s1.Hash(), s2.Hash());
        UNIT_ASSERT_EQUAL(s1, s2);
        UNIT_ASSERT_UNEQUAL(s1, s3);
    }

    Y_UNIT_TEST(TestHashAndEquals) {
        TVector<TTagName> tagNames;
        tagNames.emplace_back(0);
        tagNames.emplace_back(1);
        tagNames.emplace_back(2);
        tagNames.emplace_back(3);
        tagNames.emplace_back(6);
        tagNames.emplace_back(7);

        auto firstTagSet = TTagNameSet(tagNames);
        size_t hashValue = THash<TTagNameSet>()(firstTagSet);
        while (std::next_permutation(tagNames.begin(), tagNames.end())) {
            auto currentTagSet = TTagNameSet(tagNames);
            size_t currentHash = THash<TTagNameSet>()(TTagNameSet(tagNames));
            UNIT_ASSERT_VALUES_EQUAL(hashValue, currentHash);
            UNIT_ASSERT_EQUAL(firstTagSet, currentTagSet);
        }
    }

}
