#include "verification.h"

#include <re2/re2.h>

/* solomon labels: https://wiki.yandex-team.ru/solomon/userguide/datamodel/#ogranichenijanametkiiixznachenija
 * nanny service: https://bb.yandex-team.ru/projects/NANNY/repos/nanny/browse/nanny/src/nanny/model/docs/consts.py#5
 * gencfg group: ^[A-Z][A-Z0-9_]+[A-Z0-9]$
*/

bool NTags::IsCorrectTagName(TStringBuf value) {
    static const re2::RE2 regexp("[a-z][0-9a-z_]{1,31}");
    return RE2::FullMatch(re2::StringPiece(value), regexp);
}

bool NTags::IsCorrectItype(TStringBuf value) {
    // NOTE(rocco66): we need it for stockpile, see https://st.yandex-team.ru/GOLOVAN-6591
    // 41 = 55 - len("yasm_") - len("_group_64")
    static const re2::RE2 regexp("[a-zA-Z0-9_][a-zA-Z0-9-_]{0,40}");
    return RE2::FullMatch(re2::StringPiece(value), regexp);
}

bool NTags::IsCorrectInstanceTagValue(TStringBuf value) {
    static const re2::RE2 regexp("[a-zA-Z0-9@._][a-zA-Z0-9-@._]{0,127}");
    return RE2::FullMatch(re2::StringPiece(value), regexp);
}

bool NTags::IsCorrectRequestTagValue(TStringBuf value) {
    static const re2::RE2 regexp("[a-zA-Z0-9@._*][a-zA-Z0-9-@._*]{0,127}");
    return RE2::FullMatch(re2::StringPiece(value), regexp);
}
