#pragma once

#include <infra/yasm/common/points/value/abstract/value.h>

namespace NZoom {
    namespace NAccumulators {
        class TAbstractAccumulator: public NZoom::NValue::IUpdatable {
        public:
            virtual ~TAbstractAccumulator() = default;
            virtual void Clean() = 0;
            virtual const NZoom::NValue::IValue& GetValue() const = 0;

            virtual void MulNone() override;
            virtual void MulFloat(const double value) override;
            virtual void MulVec(const TVector<double>& value) override;
            virtual void MulCountedSum(const double sum, const ui64 count) override;
            virtual void MulHgram(const NHgram::THgram& value) override;
        };

        class IAbstractAccumulatorArray {
        public:
            virtual ~IAbstractAccumulatorArray() = default;

            virtual TAbstractAccumulator& Get(size_t offset) = 0;
            virtual const TAbstractAccumulator& Get(size_t offset) const = 0;

            virtual void Clean() = 0;
            virtual size_t Len() const = 0;
        };

        template <class T>
        class TTypedAccumulatorArray : public IAbstractAccumulatorArray {
        public:
            TTypedAccumulatorArray(size_t size) {
                Inner.resize(size);
            }

            TAbstractAccumulator& Get(size_t offset) override {
                return Inner.at(offset);
            }

            const TAbstractAccumulator& Get(size_t offset) const override {
                return Inner.at(offset);
            }

            void Clean() override {
                for (auto& accumulator : Inner) {
                    accumulator.Clean();
                }
            }

            size_t Len() const override {
                return Inner.size();
            }

        private:
            TVector<T> Inner;
        };
    }
}
