#include "abstract_optional.h"

#include <util/generic/algorithm.h>

using namespace NZoom::NAccumulators;


void TAbstractOptional::Clean() {
    Value.Clear();
}

const NZoom::NValue::IValue& TAbstractOptional::GetValue() const{
    if (!Value.Defined()) {
        return NZoom::NValue::TNoneValue::GetSingleton();
    }
    return *this;
}


void TAbstractOptional::MulFloat(const double value) {
    if (Value.Empty()) {
        Value = value;
    } else {
        Value = DoUpdateValue(Value.GetRef(), value);
    }
}

void TAbstractOptional::MulVec(const TVector<double>& value) {
    if (!value.empty()) {
        MulFloat(Accumulate(value, 0.0) / value.size());
    }
}

void TAbstractOptional::MulCountedSum(const double sum, const ui64 count) {
    if (count != 0) {
        MulFloat(sum / count);
    }
}
