#pragma once

#include <infra/yasm/common/points/accumulators/abstract/accumulator.h>
#include <infra/yasm/common/points/value/impl.h>


namespace NZoom {
    namespace NAccumulators {

        class TAbstractOptional: public TAbstractAccumulator, public NZoom::NValue::TOptionalFloatValue {
        public:
            virtual ~TAbstractOptional() = default;

            virtual void Clean() override final;
            virtual const NZoom::NValue::IValue& GetValue() const override final;

            virtual void MulFloat(const double value) override final;
            virtual void MulVec(const TVector<double>& value) override final;
            virtual void MulCountedSum(const double sum, const ui64 count) override final;

        protected:
            virtual double DoUpdateValue(const double current, const double update) const = 0;
        };
    }
}
