#include "average.h"

#include <util/generic/algorithm.h>

using namespace NZoom::NAccumulators;

TAverage::TAverage()
    : NZoom::NValue::TCountedSumValue(0.0, 0)
{
}

void TAverage::Clean() {
    Count = 0;
    Sum = 0.0;
}

const NZoom::NValue::IValue& TAverage::GetValue() const {
    return *this;
}

void TAverage::MulFloat(const double value) {
    Sum += value;
    ++Count;
}

void TAverage::MulVec(const TVector<double>& value) {
    Count += value.size();
    Sum = Accumulate(value, Sum);
}

void TAverage::MulCountedSum(const double sum, const ui64 count) {
    Count += count;
    Sum += sum;
}
