#pragma once

#include <infra/yasm/common/points/accumulators/abstract/accumulator.h>
#include <infra/yasm/common/points/value/impl.h>

namespace NZoom {
    namespace NAccumulators {

        // Average accumulator stores sum and count of gathered values,
        // it's value is an arithmetic mean of all values if any value is provied
        // or 'None'
        class TAverage: public TAbstractAccumulator, public NZoom::NValue::TCountedSumValue {

        public:
            TAverage();
            virtual ~TAverage() = default;

            virtual void Clean() override final;
            virtual const NZoom::NValue::IValue& GetValue() const override;

            virtual void MulFloat(const double value) override final;
            virtual void MulVec(const TVector<double>& value) override final;
            virtual void MulCountedSum(const double sum, const ui64 count) override final;
        };

        class TAverageArray: public TTypedAccumulatorArray<TAverage> {
        public:
            using TTypedAccumulatorArray<TAverage>::TTypedAccumulatorArray;
        };
    }
}
