#include "hgram.h"

using namespace NZoom::NAccumulators;

THgram::THgram(bool small)
    : NZoom::NValue::THgramValue(NZoom::NHgram::THgram::Default(small))
{
}

THgram::THgram(THgram&& other)
    : NZoom::NValue::THgramValue(std::move(other.Value))
{
}

void THgram::Clean() {
    Value.Clean();
}

const NZoom::NValue::IValue& THgram::GetValue() const {
    return *this;
}

void THgram::MulFloat(const double value) {
    Value.MulFloat(value);
}

void THgram::MulVec(const TVector<double>& value) {
    Value.MulSlice(value);
}

void THgram::MulCountedSum(const double sum, const ui64 count) {
    if (count > 0) {
        Value.MulFloat(sum / count);
    }
}

void THgram::MulHgram(const NHgram::THgram& value) {
    Value.MulHgram(value);
}

