#pragma once

#include <infra/yasm/common/points/accumulators/abstract/accumulator.h>
#include <infra/yasm/common/points/value/impl.h>

namespace NZoom {
    namespace NAccumulators {

        // Average accumulator stores sum and count of gathered values,
        // it's value is an arithmetic mean of all values if any value is provided
        // or 'None'
        class THgram: public TAbstractAccumulator, public NZoom::NValue::THgramValue {
        public:
            THgram(bool small = true);
            THgram(THgram&& other);
            virtual ~THgram() = default;

            virtual void Clean() override final;
            virtual const NZoom::NValue::IValue& GetValue() const override final;

            virtual void MulFloat(const double value) override final;
            virtual void MulVec(const TVector<double>& value) override final;
            virtual void MulCountedSum(const double sum, const ui64 count) override final;
            virtual void MulHgram(const NHgram::THgram& value) override final;

        };

        class THgramArray: public TTypedAccumulatorArray<THgram> {
        public:
            using TTypedAccumulatorArray<THgram>::TTypedAccumulatorArray;
        };
    }
}
