#include "summ.h"

#include <util/generic/algorithm.h>

using namespace NZoom::NAccumulators;

TSumm::TSumm()
    : NZoom::NValue::TFloatValue(0.0)
{
}

void TSumm::Clean() {
    Value = 0.0;
}

const NZoom::NValue::IValue& TSumm::GetValue() const{
    return *this;
}

void TSumm::MulFloat(const double value) {
    Value += value;
}

void TSumm::MulVec(const TVector<double>& value) {
    if (!value.empty()) {
        MulFloat(Accumulate(value, 0.0) / value.size());
    }
}

void TSumm::MulCountedSum(const double sum, const ui64 count) {
    if (count != 0) {
        MulFloat(sum / count);
    }
}
