#pragma once

#include <infra/yasm/common/points/accumulators/abstract/accumulator.h>
#include <infra/yasm/common/points/value/impl.h>

namespace NZoom {
    namespace NAccumulators {

        class TSumm: public TAbstractAccumulator, public NZoom::NValue::TFloatValue {
        public:
            TSumm();
            virtual ~TSumm() = default;

            virtual void Clean() override final;
            virtual const NZoom::NValue::IValue& GetValue() const override final;

            virtual void MulFloat(const double value) override final;
            virtual void MulVec(const TVector<double>& value) override final;
            virtual void MulCountedSum(const double sum, const ui64 count) override final;
        };

        class TSummArray: public TTypedAccumulatorArray<TSumm> {
        public:
            using TTypedAccumulatorArray<TSumm>::TTypedAccumulatorArray;
        };
    }
}
