#pragma once

#include <util/generic/maybe.h>

namespace NZoom {
    namespace NAccumulators {

        enum class EAggregationMethod {
            Agent,
            Group,
            MetaGroup,
            Rollup
        };

        enum class EAccumulatorType : ui8 {
            Average,
            Counter,
            Hgram,
            Last,
            List,
            Avg,
            Max,
            Min,
            Summ,
            SummNone,
        };

        class TAggregationRules {
        private:
            EAccumulatorType Agent;
            EAccumulatorType Group;
            EAccumulatorType Metagroup;
            EAccumulatorType Rollup;
            bool DiffAggregation = false;

            constexpr TAggregationRules(EAccumulatorType agent, EAccumulatorType group, EAccumulatorType metagroup, EAccumulatorType rollup,
                bool isDiffAggregation);

        public:
            static constexpr TAggregationRules FillSame(const EAccumulatorType fill, bool isDiffAggregation) noexcept;
            static TMaybe<TAggregationRules> FromName(const TStringBuf name) noexcept;
            static TMaybe<TAggregationRules> FromFullName(const TStringBuf name) noexcept;
            static TMaybe<TAggregationRules> FromYasmConfName(const TStringBuf name) noexcept;
            TVector<std::pair<TString, TString>> GetFormattedAccumulatorTypes() const;
            EAccumulatorType GetAccumulatorType(const EAggregationMethod aggregationMethod) const noexcept;
            bool IsDiffAggregation() const noexcept;
        };

        bool TryAccumulatorTypeFromYasmConfName(const TStringBuf name, EAccumulatorType& type) noexcept;

    }
}
