#pragma once

#include <util/system/types.h>

#include <util/generic/vector.h>

namespace NZoom {
    namespace NHgram {
        static constexpr i16 MAX_NORMAL_HGRAM_SIZE = 100;
        static constexpr double HGRAM_BASE = 1.5;
        static constexpr double LOWER_BORDER_FOR_BUCKET_WITH_ZERO = 0.1;

        class TNormal {
        private:
            TVector<double> Buckets;
            size_t Zeros = 0;
            i16 StartPower = 0;
        public:
            TNormal(TVector<double>&& buckets, const size_t zeros, const i16 startPower);
            size_t Len() const noexcept;
            void MulFloat(const double value);
            void MulSlice(const TVector<double>& values);
            void MulSmallHgram(const TVector<double>& values, const size_t zeros);
            void MulNormalHgram(const TNormal& other);
            bool operator ==(const TNormal& other) const noexcept;

            const TVector<double>& GetBuckets() const noexcept;
            size_t GetZerosCount() const noexcept;
            i16 GetStartPower() const noexcept;

            static double GetHgramPower(i32 power);

            bool IsDefault() const noexcept {
                return Buckets.empty() && !Zeros;
            }

        private:
            void MulPositiveFloat(const double value);
            ssize_t ExtendDown(ssize_t indexPretendent, ui8 margin);
            ssize_t ExtendUp(ssize_t indexPretendent);
            std::pair<ssize_t, ssize_t> ExtendBounds(ssize_t startIdx, ssize_t endIdx, ui8 margin);
        };
    }
}
