#include "normal.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NHgram;

Y_UNIT_TEST_SUITE(TZoomTHgramNormalTest) {

    Y_UNIT_TEST(ExtendUpEmpty) {
        TNormal normal({}, 0, -1);
        normal.MulFloat(4.1944122207138854e+17);
        UNIT_ASSERT_EQUAL(normal.GetZerosCount(), 0);
        UNIT_ASSERT_EQUAL(normal.GetStartPower(), 1);
        UNIT_ASSERT_EQUAL(normal.GetBuckets().size(), 100);
        UNIT_ASSERT_EQUAL(normal.GetBuckets().back(), 1);
    }

    Y_UNIT_TEST(ExtendUpNonEmpty) {
        TNormal normal({}, 0, -1);
        normal.MulFloat(0);
        normal.MulFloat(1/(1.5*1.5*1.5));
        normal.MulFloat(1/1.5);

        UNIT_ASSERT_EQUAL(normal.GetZerosCount(), 1);
        UNIT_ASSERT_EQUAL(normal.GetStartPower(), -4);
        UNIT_ASSERT_EQUAL(normal.GetBuckets().size(), 3);
        UNIT_ASSERT_EQUAL(normal.GetBuckets()[1], 1);
        UNIT_ASSERT_EQUAL(normal.GetBuckets()[2], 1);

        normal.MulFloat(4.1944122207138854e+17);
        UNIT_ASSERT_EQUAL(normal.GetZerosCount(), 1);
        UNIT_ASSERT_EQUAL(normal.GetStartPower(), 1);
        UNIT_ASSERT_EQUAL(normal.GetBuckets().size(), 100);
        UNIT_ASSERT_EQUAL(normal.GetBuckets()[0], 2);
        UNIT_ASSERT_EQUAL(normal.GetBuckets()[99], 1);
    }
}

