#include "ugram_bucket.h"

#include <util/generic/algorithm.h>
#include <util/generic/xrange.h>
#include <util/stream/output.h>

using namespace NZoom::NHgram;

TUgramBucket::TUgramBucket() {
}

TUgramBucket::TUgramBucket(const double lowerBound, const double upperBound, const double weight)
    : LowerBound(lowerBound)
    , UpperBound(upperBound)
    , Weight(weight)
{
}

TUgramBucket TUgramBucket::Point(const double value, const double weight) {
    return TUgramBucket(value, value, weight);
}

bool TUgramBucket::operator ==(const TUgramBucket& other) const noexcept {
    // TODO double comparison - may be bad
    return  LowerBound == other.LowerBound && UpperBound == other.UpperBound && Weight == other.Weight;
}

bool TUgramBucket::operator !=(const TUgramBucket& other) const noexcept {
    return !(*this == other);
}

bool TUgramBucket::operator <(const TUgramBucket& other) const noexcept {
    if (LowerBound < other.LowerBound) {
        return true;
    }
    if (LowerBound == other.LowerBound) {
        return UpperBound < other.UpperBound;
    }
    return false;
}

bool TUgramBucket::operator <(const double other) const noexcept {
    return UpperBound < other;
}

double TUgramBucket::Size() const noexcept {
    return UpperBound - LowerBound;
}

bool TUgramBucket::IsPoint() const noexcept {
    return UpperBound == LowerBound;
}

template <>
void Out<TUgramBucket>(IOutputStream& stream,
                       TTypeTraits<TUgramBucket>::TFuncParam bucket) {
    stream << "TUgramBucket{" << bucket.LowerBound << " - " << bucket.UpperBound << ", Weight=" << bucket.Weight << "} ";
}
