#include <library/cpp/testing/benchmark/bench.h>

#include <infra/yasm/common/points/hgram/ugram/compress/slow.h>
#include <infra/yasm/common/points/hgram/ugram/compress/compress.h>
#include <util/random/random.h>
#include <util/string/cast.h>

using namespace NZoom::NHgram;

double InitialCompress(const TUgramBuckets& buckets, TUgramBuckets& result);

const unsigned short LIMIT_FOR_RAW_BUCKET_COUNTER = 5;
const unsigned int BUCKETS_AMOUNT = 300;

TUgramBuckets GetRandomUgramBuckets(size_t size) {
    TUgramBuckets result;
    double lowerBound = RandomNumber<ui16>();
    double upperBound;
    double weight;
    double boundsDelta = 0;
    for (size_t i = 0; i < size; i++) {
        if (boundsDelta == 0)
            boundsDelta = RandomNumber<double>() + 0.1;
        else
            boundsDelta = RandomNumber<double>();
        upperBound = lowerBound + boundsDelta;
        weight = RandomNumber<double>();
        result.push_back(TUgramBucket(lowerBound, upperBound, weight));
        lowerBound = upperBound + RandomNumber<double>();
    }
    return result;
};

Y_CPU_BENCHMARK(TestSlowCompressor_PriorityQueue, iface) {
    TUgramBuckets buffer = GetRandomUgramBuckets(BUCKETS_AMOUNT);
    TUgramBuckets result;
    const double minWidth = InitialCompress(buffer, result);
    TSlowCompressor slow;
    TRawBucketLimitCounter rawBucketCounter{buffer, LIMIT_FOR_RAW_BUCKET_COUNTER};
    for (size_t i = 0; i < iface.Iterations(); i++) {
        if (rawBucketCounter.ShouldWeCompress()) {
            buffer.clear();
            buffer.swap(result);
            slow.Compress(minWidth, buffer, result, rawBucketCounter);
            Y_DO_NOT_OPTIMIZE_AWAY(result);
        }
    }
}
