#pragma once

#include <infra/yasm/common/points/hgram/ugram/compress/fast.h>
#include <infra/yasm/common/points/hgram/ugram/compress/slow.h>

#include <infra/yasm/common/points/hgram/ugram/ugram.h>

namespace NZoom {
    namespace NHgram {

        class TUgramCompressor {
        public:
            TUgramCompressor();
            const TUgramBuckets& Compress(const TUgramBuckets& ugramBuckets, size_t bucketBorderCountLimit = 0);

            static TUgramCompressor& GetInstance();
        private:
            TUgramBuckets Buffer;
            TUgramBuckets Result;
            TFastCompressor Fast;
            TSlowCompressor Slow;
        };

        class TLazyUgramCompressor {
        public:
            TLazyUgramCompressor();
            const TUgramBuckets& Compress(const TUgramBuckets& ugramBuckets, size_t bucketBorderCountLimit = 0);

            static TLazyUgramCompressor& GetInstance();
        private:
            TUgramCompressor BaseCompressor;
        };

    }
}
