#include "compress.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NHgram;

double InitialCompress(const TUgramBuckets& buckets, TUgramBuckets& result);


Y_UNIT_TEST_SUITE(TZoomTHgramUgramCompressorTest) {

    TUgramBucket ub(const double lowerBound, const double upperBound, const double weight) {
        return TUgramBucket(lowerBound, upperBound, weight);
    }

    Y_UNIT_TEST(MergeZeros) {

        TUgramBuckets values({
            ub(2.0, 5.0, 0.0),
            ub(5.0, 10.0, 1.0),
            ub(10.0, 12.0, 3.0),
            ub(12.0, 15.0, 0.0),
            ub(15.0, 20.0, 3.0),
            ub(20.0, 25.0, 0.0),
            ub(25.0, 30.0, 0.0),
            ub(30.0, 40.0, 3.0),
            ub(40.0, 50.0, 0.0),
            ub(50.0, 60.0, 0.0)
        });
        TUgramBuckets res;
        InitialCompress(values, res);
        TUgramBuckets target({
            ub(5.0, 10.0, 1.0),
            ub(10.0, 12.0, 3.0),
            ub(15.0, 20.0, 3.0),
            ub(30.0, 40.0, 3.0)
        });
        UNIT_ASSERT_VALUES_EQUAL(res, target);
    }
}

