#pragma once

#include <infra/yasm/common/points/hgram/ugram/compress/constants.h>

#include <infra/yasm/common/points/hgram/ugram/ugram.h>

#include <util/generic/list.h>
#include <util/generic/vector.h>

namespace NZoom {
    namespace NHgram {

        constexpr size_t FAST_COMPRESS_LIMIT = UGRAM_LIMIT * 2;

        struct TMergedBuckets {
            double LowerBound = 0.0;
            double UpperBound = 0.0;
            double Weight = 0.0;
            double MinDens = 0.0;
            double MaxDens = 0.0;
            double Damage = 0.0;

            TMergedBuckets(const double minWidth, const TUgramBucket& bucket);
            TMergedBuckets(const double minWidth, const TMergedBuckets& left, const TMergedBuckets& right);
        };

        class TFastCompressor {
        private:
            TVector<TMergedBuckets> Buffer;
            TVector<TMergedBuckets> Result;

        public:
            TFastCompressor();
            void Compress(const double minWidth, const TUgramBuckets& buckets, TUgramBuckets& result);

        private:
            using TItPair = std::pair<TVector<TMergedBuckets>::const_iterator, TVector<TMergedBuckets>::const_iterator>;
            using TWindowIt = TList<TMergedBuckets>::const_iterator;

            std::pair<TWindowIt, TMergedBuckets> FindBest(const double minWidth, const TList<TMergedBuckets>& window);
            bool Iteration(const double minWidth, TItPair& src, TList<TMergedBuckets>& window);
            void CompressLoop(const double minWidth, TFastCompressor::TItPair& src);
        };
    }
}
