#pragma once

#include <infra/yasm/common/points/hgram/ugram/compress/constants.h>

#include <infra/yasm/common/points/hgram/ugram/ugram.h>

#include <util/generic/maybe.h>

namespace NZoom {
    namespace NHgram {

        constexpr size_t SLOW_COMPRESS_LIMIT = UGRAM_LIMIT;

        class TCompressBucketsSet {
            TUgramBucket Left;
            TUgramBucket Right;
            double TotalWeight = 0.0;
            double TotalSize = 0.0;
            double MaxBucketDensity = 0.0;
            double Damage = 0.0;
            TMaybe<TUgramBucket> MergedUgrams;

        public:
            TCompressBucketsSet();
            TCompressBucketsSet(const TUgramBucket& left, const TUgramBucket& right, const double pointSize);

            void LeftMerge(TCompressBucketsSet& other);
            void RightMerge(TCompressBucketsSet& other);

            double GetDamage() const noexcept;
            const TUgramBucket& GetLeft() const noexcept;
            const TUgramBucket& GetRight() const noexcept;

        private:
            void MergeCommon(const TCompressBucketsSet& other);
        };

        size_t CountUniqueBucketBorders(const TUgramBuckets& buckets);

        class TRawBucketLimitCounter {
        public:
            TRawBucketLimitCounter(const TUgramBuckets& buckets, const size_t rawBucketLimit);
            bool ShouldWeCompress() const;
            void OpenEndedBucketWasMerged();
            void CloseEndedBucketWasMerged();
            size_t GetCounterValue() const;
        private:
            size_t Limit;
            size_t Counter;
        };

        class TSlowCompressor {
        public:
            void Compress(
                const double minWidth,
                const TUgramBuckets& buffer,
                TUgramBuckets& result,
                TRawBucketLimitCounter& rawBucketCounter
            );
        };
    }
}
