#pragma once

#include <infra/yasm/common/points/hgram/ugram/common/ugram_bucket.h>

#include <infra/yasm/common/points/hgram/normal/normal.h>

#include <util/generic/yexception.h>
#include <util/generic/ylimits.h>
#include <util/generic/vector.h>

namespace NZoom {
    namespace NHgram {

        class TUgramError : public yexception {
        };

        class TUgram {
        public:
            static const TStringBuf MARKER;
        private:
            TUgramBuckets Buckets;

        public:
            TUgram();
            TUgram(TUgramBuckets&& buckets);

            const TUgramBuckets& GetBuckets() const;
            size_t Len() const noexcept;

            void MulFloat(const double value);
            void MulSlice(const TVector<double>& values);
            void MulSmallHgram(const TVector<double>& values, const size_t zeros);
            void MulNormalHgram(const TNormal& other);
            void MulNormalHgram(const TVector<double>& buckets, const size_t zeros, const i16 startPower);
            void MulUgramHgram(const TUgram& other);
            void MulBuckets(const TUgramBuckets& buckets);
            bool operator==(const TUgram& other) const noexcept;

            void Clean() noexcept;

            bool IsDefault() const noexcept {
                return Buckets.empty();
            }

        private:
            void MulFloatInternal(const double value, const double weight);
            void MulZeros(const size_t count);

        };

        class TUgramBuilder {
        private:
            double CurrentBound = std::numeric_limits<double>::lowest();
            TUgramBuckets Buckets;

        public:
            TUgramBuilder() = default;
            TUgramBuilder(const size_t capacity);
            TUgramBuilder(TUgramBuckets&& buckets);

            void Add(const TUgramBucket& bucket);
            TUgram Build();
        };

    }
}
