#pragma once

#include <infra/yasm/common/points/hgram/hgram.h>

#include <infra/yasm/common/points/value/types.h>

#include <util/generic/maybe.h>

namespace NZoom::NHgram {
    class TUgramBucketsFreezer {
    public:
        TUgramBucketsFreezer(NZoom::NHgram::TUgramBuckets frozenBuckets);

        const NZoom::NHgram::TUgramBuckets& GetBuckets() const {
            return BucketsBuffer;
        };

        const NZoom::NHgram::TUgramBuckets& Freeze(const NZoom::NHgram::TUgramBuckets& bucketsForFreeze);
    private:
        NZoom::NHgram::TUgramBuckets BucketsBuffer;
    };

    class TUgramMerger final: public NZoom::NValue::IUpdatable {
    public:
        TUgramMerger()
            : UgramMergeResult{}
            , DifferentBucketsCounter{}
        {
        }

        // NOTE(rocco66): IUpdatable interface
        void MulNone() override {};
        void MulFloat(double value) override {
            Y_FAIL("Float in TUgramMerger");
            Y_UNUSED(value);
        };
        void MulVec(const TVector<double>& value) override {
            Y_FAIL("Vector in TUgramMerger");
            Y_UNUSED(value);
        };
        void MulCountedSum(double sum, ui64 count) override {
            Y_FAIL("CountedSum in TUgramMerger");
            Y_UNUSED(sum, count);
        };
        void MulHgram(const NZoom::NHgram::THgram& value) override;

        // NOTE(rocco66): other methods
        void CheckAndMulBuckets(const NZoom::NHgram::TUgramBuckets& buckets);

        TMaybe<TUgramBucketsFreezer> GetFreezer(size_t limit);
    private:
        bool Compress(size_t limit);

        NZoom::NHgram::TUgram UgramMergeResult;
        ui64 DifferentBucketsCounter;
    };

}
