#include "impl.h"

using namespace NZoom::NValue;

namespace {
    static const TNoneValue NONE_VALUE;
}

TFloatValue::TFloatValue(const double value)
    : Value(value)
{
}

void TFloatValue::Update(IUpdatable& accumulator) const {
    accumulator.MulFloat(Value);
}


TOptionalFloatValue::TOptionalFloatValue()
{
}

TOptionalFloatValue::TOptionalFloatValue(const double value)
    : Value(value)
{
}

void TOptionalFloatValue::Update(IUpdatable& accumulator) const {
    if (Value.Defined()) {
        accumulator.MulFloat(Value.GetRef());
    } else {
        accumulator.MulNone();
    }
}


TVecValue::TVecValue(TVector<double> value)
    : Value(std::move(value))
{
}

void TVecValue::Update(IUpdatable& accumulator) const {
    accumulator.MulVec(Value);
}


void TNoneValue::Update(IUpdatable& accumulator) const {
    accumulator.MulNone();
}

const TNoneValue& TNoneValue::GetSingleton() {
    return NONE_VALUE;
}

TCountedSumValue::TCountedSumValue(const double sum, const ui64 count)
    : Sum(sum)
    , Count(count)
{
}

void TCountedSumValue::Update(IUpdatable& accumulator) const {
    accumulator.MulCountedSum(Sum, Count);
}

THgramValue::THgramValue(NHgram::THgram value)
    : Value(std::move(value))
{
}

void THgramValue::Update(IUpdatable& accumulator) const {
    accumulator.MulHgram(Value);
}


THyperLogLogValue::THyperLogLogValue(const ::THyperLogLog& /*value*/)
//    : Value(value)
{
}

void THyperLogLogValue::Update(IUpdatable& /*accumulator*/) const {
}

