#pragma once

#include <infra/yasm/common/points/value/abstract/value.h>


namespace NZoom {
    namespace NValue {

        class TValueRef {
        private:
            const IValue* Value;

        public:
            TValueRef();

            inline TValueRef(const IValue& value)
                : Value(&value)
            {
            }

            inline void Update(IUpdatable& accumulator) const {
                Value->Update(accumulator);
            }

            EValueType GetType() const noexcept {
                return Value->GetType();
            }

            bool IsDefault() const noexcept {
                return Value->IsDefault();
            }

            bool operator==(const TValueRef& other) const noexcept;

            inline bool operator!=(const TValueRef& other) const noexcept {
                return !(*this == other);
            }
        };


        struct TMetricManager : public IUpdatable {
            ui64 TotalPoints = 0;
            ui64 NegativePoints = 0;
            ui64 NonePoints = 0;
            ui64 TotalHgrams = 0;
            ui64 HgramsLen = 0;
            ui64 TotalUgrams = 0;
            ui64 UgramsLen = 0;
            ui64 TotalLists = 0;
            ui64 ListsLen = 0;

            void MulNone() override final;
            void MulFloat(const double value) override final;
            void MulVec(const TVector<double>& value) override final;
            void MulCountedSum(const double sum, const ui64 count) override final;
            void MulHgram(const NHgram::THgram& value) override final;
            void MulHyperLogLog(const ::THyperLogLog& value) override final;
        };

        class TValue {
        public:
            inline TValue(TValue&& other) noexcept
                : Value(std::move(other.Value))
            {
            }

            TValue(const TValueRef& other);
            TValue();
            TValue(const double sum, const ui64 count);
            explicit TValue(NHgram::THgram value);
            explicit TValue(const double value);
            explicit TValue(TVector<double> value);
            explicit TValue(const ::THyperLogLog& value);

            inline TValueRef GetValue() const noexcept {
                return TValueRef(*Value);
            }

            const IValue& GetRawValue() const noexcept {
                return *Value;
            }

            void inline Update(IUpdatable& accumulator) const {
                Value->Update(accumulator);
            }

            EValueType GetType() const noexcept {
                return Value->GetType();
            }

            bool IsDefault() const noexcept {
                return Value->IsDefault();
            }

            inline void operator=(TValue&& other) noexcept {
                Value = std::move(other.Value);
            }

            bool operator==(const TValue& other) const;
        private:
            TValue(THolder<IValue> rawValue)
                : Value(std::move(rawValue)) {
            }

            THolder<IValue> Value;

            friend class TValueCopier;
        };

        class TValueCopier: public IUpdatable {
        public:
            TValueCopier() = default;

            TValue ExtractValue();
            THolder<IValue> ExtractRawValue();

            void MulNone() final;
            void MulFloat(const double value) final;
            void MulVec(const TVector<double>& value) final;
            void MulCountedSum(const double sum, const ui64 count) final;
            void MulHgram(const NZoom::NHgram::THgram& value) final;
            void MulHyperLogLog(const ::THyperLogLog& value)final;
        private:
            THolder<IValue> ImplHolder;
        };
    }
}
