#include "types.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NValue;
using namespace NZoom::NHgram;

Y_UNIT_TEST_SUITE(TZoomTValueTest) {
    Y_UNIT_TEST(Types) {
        UNIT_ASSERT_EQUAL(TValue().GetType(), EValueType::NONE);
        UNIT_ASSERT_EQUAL(TValue(42.0).GetType(), EValueType::FLOAT);
        UNIT_ASSERT_EQUAL(TValue(42.0, 10).GetType(), EValueType::COUNTED_SUM);
        UNIT_ASSERT_EQUAL(TValue(TVector<double>{1.0, 2.0, 3.0}).GetType(), EValueType::VEC);
        UNIT_ASSERT_EQUAL(TValue(THgram::Small(TVector<double>{}, 0)).GetType(), EValueType::SMALL_HGRAM);
        UNIT_ASSERT_EQUAL(TValue(THgram::Normal(TVector<double>{}, 0, 0)).GetType(), EValueType::NORMAL_HGRAM);
        UNIT_ASSERT_EQUAL(TValue(THgram::EmptyUgram()).GetType(), EValueType::USER_HGRAM);
    }

    Y_UNIT_TEST(Default) {
        UNIT_ASSERT(TValue().IsDefault());
        UNIT_ASSERT(!TValue(42.0).IsDefault());

        UNIT_ASSERT(TValue(0.0, 0).IsDefault());
        UNIT_ASSERT(!TValue(42.0, 10).IsDefault());

        UNIT_ASSERT(TValue(TVector<double>{}).IsDefault());
        UNIT_ASSERT(!TValue(TVector<double>{1.0, 2.0, 3.0}).IsDefault());

        UNIT_ASSERT(TValue(THgram::Small(TVector<double>{}, 0)).IsDefault());
        UNIT_ASSERT(!TValue(THgram::Small(TVector<double>{1.0, 2.0, 3.0}, 0)).IsDefault());

        UNIT_ASSERT(TValue(THgram::Normal(TVector<double>{}, 0, 0)).IsDefault());
        UNIT_ASSERT(!TValue(THgram::Normal(TVector<double>{1.0, 2.0, 3.0}, 0, 0)).IsDefault());

        UNIT_ASSERT(TValue(THgram::EmptyUgram()).IsDefault());
        UNIT_ASSERT(!TValue(THgram::Ugram(TUgramBuckets{TUgramBucket(0.0, 1.0, 1.0)})).IsDefault());
    }
}
