#include "ready_handle.h"

using namespace NYasm::NCommon;

void TReadyHandler::Handle(TProtoContext& context) {
    TGuard<TAdaptiveLock> guard(Lock);
    context.Response.SetUptime(Started.Seconds());
    context.Response.SetStatusCode(StatusCode);
    if (StatusCode != EStatusCode::TReadyResponse_EStatusCode_OK) {
        context.ReplyingContext.ResponceCode = HttpCodes::HTTP_SERVICE_UNAVAILABLE;
    }
}

void TReadyHandler::SetStatusCode(EStatusCode statusCode) {
    TGuard<TAdaptiveLock> guard(Lock);
    StatusCode = statusCode;
}
