#pragma once

#include "metrics.h"

#include <infra/yasm/interfaces/internal/ready_api.pb.h>
#include <infra/monitoring/common/proto_replier.h>

namespace NYasm::NCommon {
    class TReadyHandler final : public NMonitoring::TAbstractProtoReplier<NInterfaces::NInternal::TReadyRequest, NInterfaces::NInternal::TReadyResponse> {
    public:
        using EStatusCode = NInterfaces::NInternal::TReadyResponse::EStatusCode;

        TReadyHandler(TLog& logger, EStatusCode statusCode)
            : Logger(logger)
            , Started(TInstant::Now())
            , StatusCode(statusCode)
        {
        }

        TReadyHandler(TLog& logger)
            : TReadyHandler(logger, EStatusCode::TReadyResponse_EStatusCode_OK)
        {
        }

        void SetStatusCode(NInterfaces::NInternal::TReadyResponse::EStatusCode statusCode);

        void Handle(TProtoContext& context) override;

        bool AllowEmptyRequest() const override {
            return true;
        }

        const TString& GetTimingMetricName() const override {
            return NMetrics::COMMON_READY_HANDLE_TIME;
        }

        TLog& GetLogger() override {
            return Logger;
        }

    private:
        TLog& Logger;
        const TInstant Started;

        EStatusCode StatusCode;
        TAdaptiveLock Lock;
    };
}
