#include "ready_handle.h"

#include <infra/monitoring/common/proto_replier_ut.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NYasm::NCommon;

Y_UNIT_TEST_SUITE(ReadyReplierTest) {
    Y_UNIT_TEST(TestFailed) {
        TLog logger;
        TReadyHandler replier(logger);
        replier.SetStatusCode(TReadyHandler::EStatusCode::TReadyResponse_EStatusCode_FAILED);
        auto httpResponse = NMonitoring::THttpRequestBuilder().Execute(replier);
        UNIT_ASSERT_VALUES_EQUAL(httpResponse.Code, 503);

        NYasm::NInterfaces::NInternal::TReadyResponse response;
        NProtobufJson::Json2Proto(httpResponse.Content, response);
        UNIT_ASSERT(response.GetUptime());
        UNIT_ASSERT_EQUAL(response.GetStatusCode(), TReadyHandler::EStatusCode::TReadyResponse_EStatusCode_FAILED);
    }

    Y_UNIT_TEST(TestSuccess) {
        TLog logger;
        TReadyHandler replier(logger);
        auto httpResponse = NMonitoring::THttpRequestBuilder().Execute(replier);
        UNIT_ASSERT_VALUES_EQUAL(httpResponse.Code, 200);

        NYasm::NInterfaces::NInternal::TReadyResponse response;
        NProtobufJson::Json2Proto(httpResponse.Content, response);
        UNIT_ASSERT(response.GetUptime());
        UNIT_ASSERT_EQUAL(response.GetStatusCode(), TReadyHandler::EStatusCode::TReadyResponse_EStatusCode_OK);
    }
}
