#pragma once

#include <library/cpp/logger/log.h>

#include <util/datetime/base.h>
#include <util/string/builder.h>

namespace NYasm::NCommon::NTest {
    inline TString SimpleLogFormatter(ELogPriority, TStringBuf data) {
        TStringBuilder result;
        result << TInstant::Now().ToStringLocalUpToSeconds() << " ";
        return result << data << Endl;
    }

    inline TLog CreateLog() {
        TLog log;
        log.ResetBackend(CreateLogBackend("cerr"));
        log.SetFormatter(SimpleLogFormatter);
        return log;
    }
}
