#pragma once

#include <library/cpp/threading/future/future.h>
#include <library/cpp/threading/work_stealing/queue.h>

#include <util/thread/pool.h>

namespace NYasm::NCommon {
    class TOffloadedTask: public TMoveOnly {
    public:
        using TRef = THolder<TOffloadedTask>;

        virtual ~TOffloadedTask() = default;

        virtual void operator()() = 0;
    };

    class TBaseThreadedExecutor: public TNonCopyable {
    public:
        using TFuture = NThreading::TFuture<void>;
        using TPromise = NThreading::TPromise<void>;

        TBaseThreadedExecutor(const TString& poolName, size_t poolSize, size_t queueSizeLimit = 0);

        virtual ~TBaseThreadedExecutor();

        [[nodiscard]] TFuture Add(TOffloadedTask::TRef&& task, bool major = true);
        [[nodiscard]] TFuture Add(const std::function<void()>& func, bool major = true);

        bool AddAndForget(const std::function<void()>& func, bool major = true);
        bool AddAndForget(TOffloadedTask::TRef&& task, bool major = true);

        inline std::size_t Size() const noexcept {
            return Size_;
        }

        void Stop();

    private:
        void Start(const TString& poolName, size_t queueSizeLimit);

        THolder<TWorkStealingMtpQueue> Queue_;
        const size_t Size_;
    };

    class TThreadedExecutor : public TBaseThreadedExecutor {
        Y_DECLARE_SINGLETON_FRIEND()
    public:
        static TThreadedExecutor& Get() {
            return *SingletonWithPriority<TThreadedExecutor, 100001>();
        }

    protected:
        TThreadedExecutor()
            : TBaseThreadedExecutor("TThreadedExecutor", 0)
        {
        }
    };
}
